/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.marlin;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.marlin.kwps.OldKwpsFactory;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.kwps.BrokerDescriptor;
import com.mapr.kwps.KTopicDescriptor;
import com.mapr.kwps.KTopicsAdmin;
import com.mapr.kwps.KwpsFactory;
import com.mapr.kwps.KwpsManager;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class KafkaTopicCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(KafkaTopicCommands.class);
    private static final String TOPIC_PARAM_NAME = "topic";
    private static final String NUM_PARTITIONS_PARAM_NAME = "partitions";
    private static final String TTL_PARAM_NAME = "ttl";
    private static final String OWN_VOLUME_PARAM_NAME = "ownvolume";
    private static final String COMPRESSION_PARAM_NAME = "compression";
    private static final String TOPIC_REGEX_PARAM_NAME = "topicregex";
    private static final String TOPIC_OWNER_NAME = "owner";
    private static final String TOPIC_SIZE = "size";
    private static final String TOPIC_PARAM_TARGET = "target";
    private static final String BROKER_ID = "id";
    private static final String BROKER_HOST = "host";
    private static final String BROKER_PORT = "port";
    private static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    private static final CLICommand createCommand = new CLICommand("create", "usage: kafkatopic create -topic <topic>", KafkaTopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).put((Object)"partitions", (Object)new IntegerInputParameter("partitions", "Number of partitions. default: 1", false, null)).put((Object)"ttl", (Object)new LongInputParameter("ttl", "Time to live in seconds. default:604800", false, null)).put((Object)"ownvolume", (Object)new BooleanInputParameter("ownvolume", "Specifies if the topic should be created in its own volume. default:false", false, null)).put((Object)"compression", (Object)new TextInputParameter("compression", "off|lz4|lzf|zlib. default:off", false, null)).build(), null).setShortUsage("kafkatopic create -topic <topic>");
    private static final CLICommand linkCommand = new CLICommand("ln", "usage: kafkatopic ln -topic <topic> -target <stream_path:topic_name>", KafkaTopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).put((Object)"target", (Object)new TextInputParameter("target", "Full Qualified Path of Target Topic", true, null)).build(), null).setUsageInVisible(true).setShortUsage("kafkatopic ln -topic <topic> -target <stream_path:topic_name>");
    private static final CLICommand editCommand = new CLICommand("edit", "usage: kafkatopic edit -topic <topic> -partitions <partitions>", KafkaTopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).put((Object)"partitions", (Object)new IntegerInputParameter("partitions", "Number of partitions", false, null)).put((Object)"ttl", (Object)new LongInputParameter("ttl", "Time to live in seconds. default:604800", false, null)).put((Object)"compression", (Object)new TextInputParameter("compression", "off|lz4|lzf|zlib. default:off", false, null)).build(), null).setShortUsage("kafkatopic edit -topic <topic> -partitions <partitions>");
    private static final CLICommand infoCommand = new CLICommand("info", "usage: kafkatopic info -topic <topic>", KafkaTopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).build(), null).setShortUsage("kafkatopic info -topic <topic>");
    private static final CLICommand listCommand = new CLICommand("list", "usage: kafkatopic list -topicregex <regex>", KafkaTopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"topicregex", (Object)new TextInputParameter("topicregex", "Topic Name Regex", false, null)).build(), null).setShortUsage("kafkatopic list -topicregex <regex>");
    private static final CLICommand deleteCommand = new CLICommand("delete", "usage: kafkatopic delete -topic <topic>", KafkaTopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).build(), null).setShortUsage("kafkatopic delete -topic <topic>");
    private static final CLICommand listBrokersCommand = new CLICommand("listbrokers", "usage: kafkatopic listbrokers", KafkaTopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE).setShortUsage("kafkatopic listbrokers");
    private static final CLICommand getControllerCommand = new CLICommand("getcontroller", "usage: kafkatopic getcontroller", KafkaTopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE).setShortUsage("kafkatopic getcontroller");
    private static final CLICommand connectionPropsCommand = new CLICommand("connectionprops", "usage: kafkatopic connectionprops", KafkaTopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE).setShortUsage("kafkatopic connectionprops");
    public static final CLICommand kafkaTopicCommands = new CLICommand("kafkatopic", "kafkatopic [create|edit|delete|info]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{createCommand, editCommand, linkCommand, deleteCommand, infoCommand, listCommand, listBrokersCommand, getControllerCommand, connectionPropsCommand}).setShortUsage("kafkatopic [create|edit|delete|info|list|listbrokers|getcontroller|connectionprops]");
    protected KwpsFactory kFactory;

    public KafkaTopicCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        try {
            Class.forName("com.mapr.kafka.eventstreams.Streams");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            String errMsg = "Command execution failed! 'kafkatopic' commands requires 'mapr-kafka' package.";
            LOG.error((Object)errMsg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(38, errMsg));
            return output;
        }
        if (!super.validateInput()) {
            return output;
        }
        this.kFactory = KwpsManager.getDefaultFactory();
        if (this.kFactory == null) {
            LOG.warn((Object)"Running with old version of 'mapr-kafka' package. Some commands will be unavailable.");
            this.kFactory = new OldKwpsFactory();
        }
        try {
            String cmdName = this.cliCommand.getCommandName();
            if (cmdName.equalsIgnoreCase(createCommand.getCommandName())) {
                this.createTopic(out);
            } else if (cmdName.equalsIgnoreCase(editCommand.getCommandName())) {
                this.editTopic(out);
            } else if (cmdName.equalsIgnoreCase(linkCommand.getCommandName())) {
                this.linkTopic(out);
            } else if (cmdName.equalsIgnoreCase(infoCommand.getCommandName())) {
                this.infoTopic(out);
            } else if (cmdName.equalsIgnoreCase(listCommand.getCommandName())) {
                this.listTopics(out);
            } else if (cmdName.equalsIgnoreCase(deleteCommand.getCommandName())) {
                this.deleteTopic(out);
            } else if (cmdName.equalsIgnoreCase(listBrokersCommand.getCommandName())) {
                this.listBrokers(out);
            } else if (cmdName.equalsIgnoreCase(getControllerCommand.getCommandName())) {
                this.getController(out);
            } else if (cmdName.equalsIgnoreCase(connectionPropsCommand.getCommandName())) {
                this.printConnectionProps(out);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        return output;
    }

    private void linkTopic(final CommandOutput.OutputHierarchy out) throws Exception {
        String user = this.getUserLoginId();
        final String topicName = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
        final String topicTarget = this.getParamTextValue(TOPIC_PARAM_TARGET, 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Begin linking Kafka topic=" + topicName + " user=" + user));
        }
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (KTopicsAdmin kadmin = KafkaTopicCommands.this.kFactory.newKafkaTopicsAdmin(KafkaTopicCommands.this.getUserCredentials());){
                    kadmin.linkTopic(topicName, topicTarget);
                    KafkaTopicCommands.this.notifyMetadataChange(kadmin);
                }
                catch (IOException e) {
                    LOG.error((Object)"Link topic failed.", (Throwable)e);
                    throw e;
                }
                catch (NoSuchMethodError e) {
                    String errMsg = "maprcli command execution failed! 'kafkatopic link topic' command requires 'mapr-kafka' package from EEP 9.1.2 or later.";
                    LOG.error((Object)errMsg);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(38, errMsg));
                }
            }
        };
    }

    private void getController(final CommandOutput.OutputHierarchy out) throws Exception {
        String user = this.getUserLoginId();
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (KTopicsAdmin kadmin = KafkaTopicCommands.this.kFactory.newKafkaTopicsAdmin(KafkaTopicCommands.this.getUserCredentials());){
                    BrokerDescriptor controller = kadmin.getController();
                    if (controller != null) {
                        CommandOutput.OutputHierarchy.OutputNode brokerNode = KafkaTopicCommands.this.getBrokerNode(controller);
                        out.addNode(brokerNode);
                    } else {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(38, "No controller was found."));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Get controller failed.", (Throwable)e);
                    throw e;
                }
            }
        };
    }

    private void listBrokers(final CommandOutput.OutputHierarchy out) throws Exception {
        String user = this.getUserLoginId();
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (KTopicsAdmin kadmin = KafkaTopicCommands.this.kFactory.newKafkaTopicsAdmin(KafkaTopicCommands.this.getUserCredentials());){
                    int brokerCount = 0;
                    Iterable brokers = kadmin.listBrokers();
                    for (BrokerDescriptor brokerDesc : brokers) {
                        ++brokerCount;
                        CommandOutput.OutputHierarchy.OutputNode brokerNode = KafkaTopicCommands.this.getBrokerNode(brokerDesc);
                        out.addNode(brokerNode);
                    }
                    if (brokerCount == 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(38, "No brokers were found."));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"List brokers failed.", (Throwable)e);
                    throw e;
                }
            }
        };
    }

    private void printConnectionProps(final CommandOutput.OutputHierarchy out) throws Exception {
        String user = this.getUserLoginId();
        final CommandOutput.OutputHierarchy.OutputNode propsNode = new CommandOutput.OutputHierarchy.OutputNode();
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (KTopicsAdmin kadmin = KafkaTopicCommands.this.kFactory.newKafkaTopicsAdmin(KafkaTopicCommands.this.getUserCredentials());){
                    Map connectionProperties = kadmin.getConnectionProperties();
                    connectionProperties.forEach((key, value) -> propsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(key, value)));
                    out.addNode(propsNode);
                }
                catch (IOException e) {
                    LOG.error((Object)"Get connection properties failed.", (Throwable)e);
                    throw e;
                }
            }
        };
    }

    private void createTopic(CommandOutput.OutputHierarchy out) throws Exception {
        String user = this.getUserLoginId();
        String topicName = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Begin creating Kafka topic=" + topicName + " user=" + user));
        }
        final KTopicDescriptor topicDesc = this.fromTopicParams(topicName);
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (KTopicsAdmin kadmin = KafkaTopicCommands.this.kFactory.newKafkaTopicsAdmin(KafkaTopicCommands.this.getUserCredentials());){
                    kadmin.createTopic(topicDesc);
                    KafkaTopicCommands.this.notifyMetadataChange(kadmin);
                }
                catch (IOException e) {
                    LOG.error((Object)"Create topic failed.", (Throwable)e);
                    throw e;
                }
            }
        };
    }

    private void editTopic(CommandOutput.OutputHierarchy out) throws Exception {
        String user = this.getUserLoginId();
        String topicName = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Begin editing Kafka topic=" + topicName + " user=" + user));
        }
        final KTopicDescriptor topicDesc = this.fromTopicParams(topicName);
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (KTopicsAdmin kadmin = KafkaTopicCommands.this.kFactory.newKafkaTopicsAdmin(KafkaTopicCommands.this.getUserCredentials());){
                    kadmin.editTopic(topicDesc);
                    KafkaTopicCommands.this.notifyMetadataChange(kadmin);
                }
                catch (Exception e) {
                    LOG.error((Object)"Edit topic failed.", (Throwable)e);
                    throw e;
                }
            }
        };
    }

    private void deleteTopic(final CommandOutput.OutputHierarchy out) throws Exception {
        String user = this.getUserLoginId();
        final String topicName = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Begin deleting Kafka topic=" + topicName + " user=" + user));
        }
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (KTopicsAdmin kadmin = KafkaTopicCommands.this.kFactory.newKafkaTopicsAdmin(KafkaTopicCommands.this.getUserCredentials());){
                    if (!kadmin.deleteTopic(topicName)) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to delete topic '" + topicName + "'"));
                    } else {
                        KafkaTopicCommands.this.notifyMetadataChange(kadmin);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Delete topic failed.", (Throwable)e);
                    throw e;
                }
            }
        };
    }

    private void infoTopic(final CommandOutput.OutputHierarchy out) throws Exception {
        String user = this.getUserLoginId();
        final String topic = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Begin info topic=" + topic + " user=" + user));
        }
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (KTopicsAdmin kadmin = KafkaTopicCommands.this.kFactory.newKafkaTopicsAdmin(KafkaTopicCommands.this.getUserCredentials());){
                    KTopicDescriptor topicDesc = kadmin.getTopicDescriptor(topic);
                    out.addNode(KafkaTopicCommands.this.getTopicNode(topicDesc));
                }
                catch (Exception e) {
                    LOG.error((Object)"Info topic failed", (Throwable)e);
                    throw e;
                }
            }
        };
    }

    private void listTopics(final CommandOutput.OutputHierarchy out) throws Exception {
        String user = this.getUserLoginId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Begin topic list for user=" + user));
        }
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (KTopicsAdmin kadmin = KafkaTopicCommands.this.kFactory.newKafkaTopicsAdmin(KafkaTopicCommands.this.getUserCredentials());){
                    String topicRegex = null;
                    if (KafkaTopicCommands.this.isParamPresent(KafkaTopicCommands.TOPIC_REGEX_PARAM_NAME)) {
                        topicRegex = KafkaTopicCommands.this.getParamTextValue(KafkaTopicCommands.TOPIC_REGEX_PARAM_NAME, 0);
                    }
                    Iterable topics = kadmin.listTopics(topicRegex);
                    for (KTopicDescriptor topicDesc : topics) {
                        out.addNode(KafkaTopicCommands.this.getTopicNode(topicDesc));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"List topics failed.", (Throwable)e);
                    throw e;
                }
            }
        };
    }

    private KTopicDescriptor fromTopicParams(String topicName) throws CLIProcessingException {
        KTopicDescriptor topicDesc = new KTopicDescriptor(topicName);
        if (this.isParamPresent(NUM_PARTITIONS_PARAM_NAME)) {
            int nFeed = this.getParamIntValue(NUM_PARTITIONS_PARAM_NAME, 0);
            if (nFeed < 1) {
                throw new CLIProcessingException("Invalid value " + nFeed + " for partitions, must be >=1");
            }
            topicDesc.setPartitions(nFeed);
        }
        if (this.isParamPresent(TTL_PARAM_NAME)) {
            long ttl = this.getParamLongValue(TTL_PARAM_NAME, 0);
            topicDesc.setTtl(ttl);
        }
        if (this.isParamPresent(OWN_VOLUME_PARAM_NAME)) {
            boolean ownVolume = this.getParamBooleanValue(OWN_VOLUME_PARAM_NAME, 0);
            topicDesc.setOwnVolume(ownVolume);
        }
        if (this.isParamPresent(COMPRESSION_PARAM_NAME)) {
            String ctype = this.getParamTextValue(COMPRESSION_PARAM_NAME, 0);
            topicDesc.setCompression(ctype);
        }
        return topicDesc;
    }

    private CommandOutput.OutputHierarchy.OutputNode getBrokerNode(BrokerDescriptor brokerDesc) {
        CommandOutput.OutputHierarchy.OutputNode brokerNode = new CommandOutput.OutputHierarchy.OutputNode();
        brokerNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(BROKER_ID, brokerDesc.getId()));
        Map props = brokerDesc.getProps();
        for (Map.Entry prop : props.entrySet()) {
            String key = (String)prop.getKey();
            if (key.equals(BOOTSTRAP_SERVERS_CONFIG)) {
                String bootStrap = (String)prop.getValue();
                String[] hostPort = bootStrap.split(":");
                brokerNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(BROKER_HOST, (Object)hostPort[0]));
                brokerNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(BROKER_PORT, (Object)hostPort[1]));
                continue;
            }
            brokerNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(key, prop.getValue()));
        }
        return brokerNode;
    }

    private CommandOutput.OutputHierarchy.OutputNode getTopicNode(KTopicDescriptor desc) {
        CommandOutput.OutputHierarchy.OutputNode topicNode = new CommandOutput.OutputHierarchy.OutputNode();
        topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(TOPIC_PARAM_NAME, (Object)desc.getTopic()));
        topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(TOPIC_OWNER_NAME, (Object)desc.getOwner()));
        topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(NUM_PARTITIONS_PARAM_NAME, desc.getPartitions()));
        topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(TTL_PARAM_NAME, desc.getTtl()));
        topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(COMPRESSION_PARAM_NAME, (Object)desc.getCompressionString()));
        topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(TOPIC_SIZE, desc.getSize()));
        topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(OWN_VOLUME_PARAM_NAME, (Object)desc.isOwnVolume()));
        return topicNode;
    }

    private void notifyMetadataChange(KTopicsAdmin kadmin) {
        try {
            kadmin.notifyMetadataChange();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to notify metadata change to Kafka service", (Throwable)e);
        }
    }
}

