/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.EmailInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.BillingProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class UsageExportCommands
extends CLIBaseClass
implements CLIInterface {
    public static final String USAGE_PARAM_NAME = "usage";
    public static final String EXPORT_PARAM_NAME = "export";
    public static final String STATUS_PARAM_NAME = "status";
    public static final String SUMMARY_PARAM = "summary";
    public static final String SUMMARY_USAGE = "{connected | airgapped}";
    public static final String STATUS_USAGE = "status [-summary {connected | airgapped} ]";
    public static final String EMAIL_FREQUENCY_NAME = "email-frequency";
    public static final String FREQUENCY_PARAM_NAME = "frequency";
    public static final String FREQUENCY_USAGE = "{monthly | weekly | daily | none}";
    public static final String CUST_EMAIL_PARAM_NAME = "customer-email";
    public static final String CUST_EMAIL_USAGE = "<customer-email-address>";
    public static final String EMAIL_PARAM_NAME = "email";
    public static final String EMAIL_USAGE = "email -frequency {monthly | weekly | daily | none} [-customer-email <customer-email-address>]";
    public static final String URL_PARAM_NAME = "url";
    public static final String MODE_PARAM_NAME = "mode";
    public static final String REGISTER_URL_PARAM_NAME = "registerUrl";
    public static final String UPLOAD_URL_PARAM_NAME = "uploadUrl";
    public static final String RENEWCREDS_URL_PARAM_NAME = "renewCredsUrl";
    public static final String PROXY_URL_PARAM_NAME = "proxyUrl";
    public static final String DEV_URLS_PARAM_NAME = "devUrls";
    public static final String urlUsage = "url [-registerUrl <url> | -uploadUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]";
    public static final String KEYFILE_USAGE = "<path-to-keyfile>";
    public static final String KEYFILE_PARAM_NAME = "keyFile";
    public static final String KEY_USAGE = "<key-as-string>";
    public static final String KEY_PARAM_NAME = "key";
    public static final String REGISTER_PARAM_NAME = "register";
    public static final String REGISTER_USAGE = "register {-keyFile <path-to-keyfile>| -key <key-as-string> }";
    public static final String RENEW_PARAM_NAME = "renew";
    public static final String RENEW_USAGE = "renew {-keyFile <path-to-keyfile>| -key <key-as-string> }";
    public static final String BILLING_PARAM_NAME = "billing";
    public static final String COMMIT_AMOUNT_PARAM = "commitAmountGB";
    public static final String COMMIT_RATE_PARAM = "commitRate";
    public static final String DEMAND_RATE_PARAM = "onDemandRate";
    public static final String BILLING_USAGE = "billing {-status | -commitAmountGB <commitAmount> -commitRate <rate> -onDemandRate <rate> }";
    public static final String exportUsage = "usage export {status [-summary {connected | airgapped} ]| email -frequency {monthly | weekly | daily | none} [-customer-email <customer-email-address>] | url [-registerUrl <url> | -uploadUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]|-mode [connected | airgapped]|renew {-keyFile <path-to-keyfile>| -key <key-as-string> }|register {-keyFile <path-to-keyfile>| -key <key-as-string> }|billing {-status | -commitAmountGB <commitAmount> -commitRate <rate> -onDemandRate <rate> }}";
    private static final Logger LOG = Logger.getLogger(UsageExportCommands.class);
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static final CLICommand statusSubCommand = new CLICommand("status", "status [-summary {connected | airgapped} ]", UsageExportCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"summary", (Object)new TextInputParameter("summary", "{connected | airgapped}", false, null)).build(), null).setShortUsage("status [-summary {connected | airgapped} ]");
    public static final CLICommand emailSubCommand = new CLICommand("email", "usage export {status [-summary {connected | airgapped} ]| email -frequency {monthly | weekly | daily | none} [-customer-email <customer-email-address>] | url [-registerUrl <url> | -uploadUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]|-mode [connected | airgapped]|renew {-keyFile <path-to-keyfile>| -key <key-as-string> }|register {-keyFile <path-to-keyfile>| -key <key-as-string> }|billing {-status | -commitAmountGB <commitAmount> -commitRate <rate> -onDemandRate <rate> }}", UsageExportCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"frequency", (Object)new TextInputParameter("frequency", "{monthly | weekly | daily | none}", true, null)).put((Object)"customer-email", (Object)new EmailInputParameter("customer-email", "<customer-email-address>", false, null)).build(), null).setShortUsage("email -frequency {monthly | weekly | daily | none} [-customer-email <customer-email-address>]");
    public static final CLICommand urlSubCommand = new CLICommand("url", "url [-registerUrl <url> | -uploadUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]", UsageExportCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"registerUrl", (Object)new TextInputParameter("registerUrl", "<register-url>", false, null)).put((Object)"uploadUrl", (Object)new TextInputParameter("uploadUrl", "<upload-url>", false, null)).put((Object)"renewCredsUrl", (Object)new TextInputParameter("renewCredsUrl", "<renew-creds-url>", false, null)).put((Object)"proxyUrl", (Object)new TextInputParameter("proxyUrl", "<proxy-url>", false, null)).put((Object)"devUrls", (Object)new BooleanInputParameter("devUrls", "urls for dev billing cluster", false, Boolean.valueOf(false)).setInvisible(true)).build(), null).setShortUsage("url [-registerUrl <url> | -uploadUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]");
    public static final CLICommand exportCommand = new CLICommand("export", "export usage status", UsageExportCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"mode", (Object)new TextInputParameter("mode", "<mode>", false, null)).build(), new CLICommand[]{statusSubCommand, emailSubCommand, urlSubCommand}).setShortUsage("usage export {status [-summary {connected | airgapped} ]| email -frequency {monthly | weekly | daily | none} [-customer-email <customer-email-address>] | url [-registerUrl <url> | -uploadUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]|-mode [connected | airgapped]|renew {-keyFile <path-to-keyfile>| -key <key-as-string> }|register {-keyFile <path-to-keyfile>| -key <key-as-string> }|billing {-status | -commitAmountGB <commitAmount> -commitRate <rate> -onDemandRate <rate> }}");
    public static final CLICommand registerCommand = new CLICommand("register", "register {-keyFile <path-to-keyfile>| -key <key-as-string> }", UsageExportCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"keyFile", (Object)new TextInputParameter("keyFile", "<path-to-keyfile>", false, null)).put((Object)"key", (Object)new TextInputParameter("key", "<key-as-string>", false, null)).build(), null).setShortUsage("register {-keyFile <path-to-keyfile>| -key <key-as-string> }");
    public static final CLICommand renewCommand = new CLICommand("renew", "renew {-keyFile <path-to-keyfile>| -key <key-as-string> }", UsageExportCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"keyFile", (Object)new TextInputParameter("keyFile", "<path-to-keyfile>", false, null)).put((Object)"key", (Object)new TextInputParameter("key", "<key-as-string>", false, null)).build(), null).setShortUsage("renew {-keyFile <path-to-keyfile>| -key <key-as-string> }");
    public static final CLICommand billingStatusSubCommand = new CLICommand("status", "billing {-status | -commitAmountGB <commitAmount> -commitRate <rate> -onDemandRate <rate> }", UsageExportCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, null).setShortUsage("status [-summary {connected | airgapped} ]");
    public static final CLICommand billingCommand = new CLICommand("billing", "renew {-keyFile <path-to-keyfile>| -key <key-as-string> }", UsageExportCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"commitAmountGB", (Object)new TextInputParameter("commitAmountGB", "commitAmountGB", true, null)).put((Object)"commitRate", (Object)new TextInputParameter("commitRate", "commitRate", true, null)).put((Object)"onDemandRate", (Object)new TextInputParameter("onDemandRate", "onDemandRate", true, null)).build(), new CLICommand[]{billingStatusSubCommand}).setShortUsage("billing {-status | -commitAmountGB <commitAmount> -commitRate <rate> -onDemandRate <rate> }");
    public static final CLICommand usageCommand = new CLICommand("usage", "usage commands", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{exportCommand, renewCommand, registerCommand, billingCommand}).setShortUsage("usage export {status [-summary {connected | airgapped} ]| email -frequency {monthly | weekly | daily | none} [-customer-email <customer-email-address>] | url [-registerUrl <url> | -uploadUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]|-mode [connected | airgapped]|renew {-keyFile <path-to-keyfile>| -key <key-as-string> }|register {-keyFile <path-to-keyfile>| -key <key-as-string> }|billing {-status | -commitAmountGB <commitAmount> -commitRate <rate> -onDemandRate <rate> }}");

    public UsageExportCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private void updateUsageEmailConfig(String cluster, CommandOutput.OutputHierarchy out, CLDBProto.UsageEmailFrequency freq, String custEmail) throws CLIProcessingException {
        CLDBProto.UsageEmailConfigResponse resp = null;
        CLDBProto.UsageEmailConfigRequest.Builder req = CLDBProto.UsageEmailConfigRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        req.setEmailFreq(freq);
        req.setCustEmail(custEmail);
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageConfigUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageEmailConfigResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageConfigUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageEmailConfigResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response, check cldb logs."));
                return;
            }
            resp = CLDBProto.UsageEmailConfigResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            String errMsg = Errno.toString((int)resp.getStatus());
            errMsg = resp.getStatus() == 38 ? "please update maprcli to the compatible version." : errMsg;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Getting usage config failed. " + errMsg));
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode configStatusNode = new CommandOutput.OutputHierarchy.OutputNode("config");
        configStatusNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("updateStatus", (Object)Errno.toString((int)resp.getConfigUpdateStatus())));
        out.addNode(configStatusNode);
    }

    private String epochSecsToStr(long secs) {
        if (secs == 0L) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
        dateFormat.setTimeZone(TimeZone.getDefault());
        String retStr = dateFormat.format(new Date(secs * 1000L));
        return retStr;
    }

    private void registerActivationKey(CommandOutput.OutputHierarchy out, String keyFile, String key, String cluster) throws CLIProcessingException {
        CLDBProto.RegisterKeyResponse resp = null;
        CLDBProto.RegisterKeyRequest.Builder req = CLDBProto.RegisterKeyRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        String jsonString = "";
        if (key != null) {
            jsonString = key;
        } else if (keyFile != null) {
            try {
                jsonString = new String(Files.readAllBytes(Paths.get(keyFile, new String[0])));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage());
                throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
            }
        }
        req.setKey(jsonString);
        LOG.debug((Object)("JSON string is " + jsonString));
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.RegisterKeyProc.getNumber(), (MessageLite)req.build(), CLDBProto.RegisterKeyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.RegisterKeyProc.getNumber(), (MessageLite)req.build(), CLDBProto.RegisterKeyResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response, check cldb logs."));
                return;
            }
            resp = CLDBProto.RegisterKeyResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            String errMsg = resp.getError();
            if (errMsg.length() > 100) {
                errMsg = errMsg.substring(errMsg.length() - 100);
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Could not activate key " + errMsg));
            return;
        }
        LOG.info((Object)("Received status" + resp.getStatus() + " expiry date " + resp.getExpiryDate()));
        CommandOutput.OutputHierarchy.OutputNode registerKeyNode = new CommandOutput.OutputHierarchy.OutputNode(REGISTER_PARAM_NAME);
        if (resp.hasExpiryDate()) {
            String expiryTimeStr = "";
            expiryTimeStr = this.epochSecsToStr(resp.getExpiryDate());
            registerKeyNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("activeTill", (Object)expiryTimeStr));
        }
        out.addNode(registerKeyNode);
    }

    private void getUsageStatus(CommandOutput.OutputHierarchy out, String cluster) throws CLIProcessingException {
        LOG.info((Object)"Inside getUsageStatus");
        String summary = "all";
        if (this.isParamPresent(SUMMARY_PARAM) && !(summary = this.getParamTextValue(SUMMARY_PARAM, 0)).equalsIgnoreCase("connected") && !summary.equalsIgnoreCase("airgapped")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid summary parameter, accepted values are 'connected' or 'airgapped'"));
            return;
        }
        CLDBProto.UsageStatusResponse resp = null;
        CLDBProto.UsageStatusRequest.Builder req = CLDBProto.UsageStatusRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageStatusResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageStatusResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response, check cldb logs."));
                return;
            }
            resp = CLDBProto.UsageStatusResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            String errMsg = Errno.toString((int)resp.getStatus());
            errMsg = resp.getStatus() == 38 ? "please update maprcli to the compatible version." : errMsg;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Getting usage status failed. " + errMsg));
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode usageStatusNode = new CommandOutput.OutputHierarchy.OutputNode(USAGE_PARAM_NAME);
        if (resp.hasClusterId()) {
            usageStatusNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("clusterId", (Object)resp.getClusterId()));
        }
        if (resp.hasUsageExportMode()) {
            CLDBProto.ClusterUsageExportModeInfo modeInfo = resp.getUsageExportMode();
            usageStatusNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("clusterUsageMode", (Object)modeInfo.getMode()));
        }
        LOG.info((Object)("Expirty Time in status is " + resp.getExpiryTime()));
        if (resp.hasExpiryTime() && (summary.equalsIgnoreCase("airgapped") || summary.equalsIgnoreCase("all"))) {
            String expiryTimeStr = "";
            String startTimeStr = "";
            String isRegistered = "No";
            CommandOutput.OutputHierarchy.OutputNode airgapNode = new CommandOutput.OutputHierarchy.OutputNode("airgapped");
            if (resp.getExpiryTime() > 0L) {
                if (resp.hasInfoSigningKey() && resp.getInfoSigningKey().hasKey() && resp.getInfoSigningKey().getKey().length() > 0) {
                    isRegistered = "Yes";
                    startTimeStr = this.epochSecsToStr(resp.getInfoSigningKey().getStartDate());
                } else {
                    isRegistered = "Waiting for activation Key";
                }
                LOG.info((Object)("Expirty Time in status is " + resp.getExpiryTime()));
                expiryTimeStr = this.epochSecsToStr(resp.getExpiryTime());
            }
            airgapNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("Registered", (Object)isRegistered));
            airgapNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("StartDate", (Object)startTimeStr));
            airgapNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("activeTill", (Object)expiryTimeStr));
            usageStatusNode.addChild(airgapNode);
        }
        if (summary.equalsIgnoreCase("all")) {
            CommandOutput.OutputHierarchy.OutputNode emailNode = new CommandOutput.OutputHierarchy.OutputNode(EMAIL_PARAM_NAME);
            if (resp.hasHpeEmailAddr()) {
                emailNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("hpeEmail", (Object)resp.getHpeEmailAddr()));
            }
            if (resp.hasCustomerEmailAddr()) {
                emailNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("customerEmail", (Object)resp.getCustomerEmailAddr()));
            }
            if (resp.hasEmailFreq()) {
                CLDBProto.UsageEmailFrequency emailFreq = CLDBProto.UsageEmailFrequency.EmailNone;
                emailFreq = resp.getEmailFreq();
                emailNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("emailFrequency", (Object)emailFreq.toString()));
            }
            if (resp.hasLastEmailAttemptTime()) {
                String lastEmailAttemptTimeStr = "None";
                lastEmailAttemptTimeStr = this.epochSecsToStr(resp.getLastEmailAttemptTime());
                emailNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastEmailAttempt", (Object)lastEmailAttemptTimeStr));
            }
            if (resp.hasLastEmailStatus()) {
                emailNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastEmailStatus", resp.getLastEmailStatus()));
            }
            if (resp.hasLastEmailFailureReason()) {
                emailNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastEmailFailureReason", (Object)resp.getLastEmailFailureReason()));
            }
            usageStatusNode.addChild(emailNode);
        }
        if (resp.hasUsageReportStatus() && (summary.equalsIgnoreCase("connected") || summary.equalsIgnoreCase("all"))) {
            CLDBProto.UsageReportStatus rs = resp.getUsageReportStatus();
            String smState = "";
            switch (rs.getSmState()) {
                case WAITING_FOR_LICENSE: {
                    smState = "Waiting for License";
                    break;
                }
                case REGISTRATION: {
                    smState = "Registration";
                    break;
                }
                case UPLOAD_USAGE: {
                    smState = "Upload Usage";
                    break;
                }
                case RENEW_CREDS: {
                    smState = "Renew Creds";
                }
                default: {
                    smState = "NONE";
                }
            }
            CommandOutput.OutputHierarchy.OutputNode urNode = new CommandOutput.OutputHierarchy.OutputNode("connMode");
            urNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("reportState", (Object)smState));
            CommandOutput.OutputHierarchy.OutputNode regNode = new CommandOutput.OutputHierarchy.OutputNode("registration");
            CommandOutput.OutputHierarchy.OutputNode upload = new CommandOutput.OutputHierarchy.OutputNode("upload");
            CommandOutput.OutputHierarchy.OutputNode renew = new CommandOutput.OutputHierarchy.OutputNode(RENEW_PARAM_NAME);
            CommandOutput.OutputHierarchy.OutputNode http = new CommandOutput.OutputHierarchy.OutputNode("httpStatus");
            if (rs.hasRegUrl()) {
                regNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("regUrl", (Object)rs.getRegUrl()));
            }
            if (rs.hasNumRegAttempts()) {
                regNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("numRegAttempts", rs.getNumRegAttempts()));
            }
            if (rs.hasLastRegAttemptEpochSecs()) {
                regNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastRegAttempt", (Object)this.epochSecsToStr(rs.getLastRegAttemptEpochSecs())));
            }
            if (rs.hasRegTimeEpochSecs()) {
                regNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("regTime", (Object)this.epochSecsToStr(rs.getRegTimeEpochSecs())));
            }
            if (rs.hasUploadUrl()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode(UPLOAD_URL_PARAM_NAME, (Object)rs.getUploadUrl()));
            }
            if (rs.hasNumUploadAttempts()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("numUploadAttempts", rs.getNumUploadAttempts()));
            }
            if (rs.hasNumUploads()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("numUploads", rs.getNumUploads()));
            }
            if (rs.hasLastUploadAttemptEpochSecs()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastUploadAttempt", (Object)this.epochSecsToStr(rs.getLastUploadAttemptEpochSecs())));
            }
            if (rs.hasLastUploadTimeEpochSecs()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastUploadTime", (Object)this.epochSecsToStr(rs.getLastUploadTimeEpochSecs())));
            }
            if (rs.hasLastUsageTimeReportedEpochSecs()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastReportedUsageTime", (Object)this.epochSecsToStr(rs.getLastUsageTimeReportedEpochSecs())));
            }
            if (rs.hasRenewUrl()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("renewUrl", (Object)rs.getRenewUrl()));
            }
            if (rs.hasNumRenewAttempts()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("numRenewAttempts", rs.getNumRenewAttempts()));
            }
            if (rs.hasLastRenewAttemptEpochSecs()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastRenewAttempt", (Object)this.epochSecsToStr(rs.getLastRenewAttemptEpochSecs())));
            }
            if (rs.hasLastRenewTimeEpochSecs()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastRenewTime", (Object)this.epochSecsToStr(rs.getLastRenewTimeEpochSecs())));
            }
            if (rs.hasNumRenews()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("numRenews", rs.getNumRenews()));
            }
            if (rs.hasHttpRequestInProgress()) {
                http.addNode(new CommandOutput.OutputHierarchy.OutputNode("requestInProgress", (Object)rs.getHttpRequestInProgress()));
            }
            if (rs.hasLastHttpStatus()) {
                http.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastHttpStatus", rs.getLastHttpStatus()));
            }
            if (rs.hasLastHttpReason()) {
                http.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastHttpReason", (Object)rs.getLastHttpReason()));
            }
            if (rs.hasLastHttpErrTime()) {
                http.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastHttpRespTime", (Object)this.epochSecsToStr(rs.getLastHttpErrTime())));
            }
            urNode.addChild(regNode);
            urNode.addChild(upload);
            urNode.addChild(renew);
            urNode.addChild(http);
            if (rs.hasNumConsFailures()) {
                urNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("numCscFailures", rs.getNumConsFailures()));
            }
            if (rs.hasProxyUrl()) {
                urNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(PROXY_URL_PARAM_NAME, (Object)rs.getProxyUrl()));
            }
            usageStatusNode.addChild(urNode);
        }
        out.addNode(usageStatusNode);
    }

    private void updateUrl(CommandOutput.OutputHierarchy out, String cluster) throws CLIProcessingException {
        CLDBProto.UsageExportUrlInfo.Builder exportUrlInfo = CLDBProto.UsageExportUrlInfo.newBuilder();
        CLDBProto.UsageExportUrlModifyRequest.Builder req = CLDBProto.UsageExportUrlModifyRequest.newBuilder();
        CLDBProto.UsageExportUrlModifyResponse resp = null;
        boolean registerParamPresent = this.isParamPresent(REGISTER_URL_PARAM_NAME);
        boolean uploadParamPresent = this.isParamPresent(UPLOAD_URL_PARAM_NAME);
        boolean renewCredsParamPresent = this.isParamPresent(RENEWCREDS_URL_PARAM_NAME);
        boolean proxyParamPresent = this.isParamPresent(PROXY_URL_PARAM_NAME);
        boolean devUrlsParamPresent = this.isParamPresent(DEV_URLS_PARAM_NAME);
        boolean urlChanged = false;
        LOG.info((Object)("reg: " + registerParamPresent + ", upload: " + uploadParamPresent + ", renew: " + renewCredsParamPresent + ", proxy: " + proxyParamPresent + ", devUrls: " + devUrlsParamPresent));
        if (registerParamPresent) {
            String registerUrl = this.getParamTextValue(REGISTER_URL_PARAM_NAME, 0);
            exportUrlInfo.setRegisterUrl(registerUrl);
            urlChanged = true;
        }
        if (uploadParamPresent) {
            String uplodaUrl = this.getParamTextValue(UPLOAD_URL_PARAM_NAME, 0);
            exportUrlInfo.setUploadUrl(uplodaUrl);
            urlChanged = true;
        }
        if (renewCredsParamPresent) {
            String renewCredsUrl = this.getParamTextValue(RENEWCREDS_URL_PARAM_NAME, 0);
            exportUrlInfo.setRenewCredsUrl(renewCredsUrl);
            urlChanged = true;
        }
        if (proxyParamPresent) {
            String proxyUrl = this.getParamTextValue(PROXY_URL_PARAM_NAME, 0);
            exportUrlInfo.setProxyUrl(proxyUrl);
            urlChanged = true;
        }
        boolean devUrls = false;
        if (devUrlsParamPresent) {
            devUrls = this.getParamBooleanValue(DEV_URLS_PARAM_NAME, 0);
            urlChanged = true;
            exportUrlInfo.setDevUrls(devUrls);
            if (devUrls && (registerParamPresent || uploadParamPresent || renewCredsParamPresent)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot provider register, upload or renew urls when devUrls is provided."));
                return;
            }
        }
        if (!urlChanged) {
            return;
        }
        req.setCreds(this.getUserCredentials());
        req.setUsageExportUrlInfo(exportUrlInfo.build());
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageExportUrlModifyProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageExportUrlModifyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageExportUrlModifyProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageExportUrlModifyResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response, check cldb logs."));
                return;
            }
            resp = CLDBProto.UsageExportUrlModifyResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        out.addMessage("export urls updated successfully! ");
    }

    private void updateExportMode(CommandOutput.OutputHierarchy out, String cluster) throws CLIProcessingException {
        String mode = this.getParamTextValue(MODE_PARAM_NAME, 0);
        boolean parseErr = false;
        if (!mode.equalsIgnoreCase("connected") && !mode.equalsIgnoreCase("airgapped")) {
            parseErr = true;
        }
        if (parseErr) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid mode parameter"));
            return;
        }
        CLDBProto.ClusterUsageExportModeResponse resp = null;
        CLDBProto.ClusterUsageExportModeRequest.Builder req = CLDBProto.ClusterUsageExportModeRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        req.setMode(mode);
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.ClusterUsageExportModeProc.getNumber(), (MessageLite)req.build(), CLDBProto.ClusterUsageExportModeResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.ClusterUsageExportModeProc.getNumber(), (MessageLite)req.build(), CLDBProto.ClusterUsageExportModeResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response, check cldb logs."));
                return;
            }
            resp = CLDBProto.ClusterUsageExportModeResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        out.addMessage("Cluster Usage mode updated successfully to " + mode);
    }

    private void getBillingStatus(CommandOutput.OutputHierarchy out, String cluster) throws CLIProcessingException {
        CLDBProto.UsageBillingResponse resp = null;
        CLDBProto.UsageBillingRequest.Builder req = CLDBProto.UsageBillingRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        req.setLoad(true);
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageBillingProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageBillingResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageBillingProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageBillingResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response, check cldb logs."));
                return;
            }
            resp = CLDBProto.UsageBillingResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode billingStatusNode = new CommandOutput.OutputHierarchy.OutputNode("billingUsage");
        if (resp.hasBillingInfo()) {
            CLDBProto.UsageBillingInfo billingInfo = resp.getBillingInfo();
            billingStatusNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(COMMIT_AMOUNT_PARAM, (Object)billingInfo.getCommitAmountGb()));
            billingStatusNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(COMMIT_RATE_PARAM, (Object)billingInfo.getCommitRate()));
            billingStatusNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("demandRate", (Object)billingInfo.getDemandRate()));
        }
        out.addNode(billingStatusNode);
    }

    private void updateBillingParameters(CommandOutput.OutputHierarchy out, String cluster) throws CLIProcessingException {
        String commitAmountGb = this.getParamTextValue(COMMIT_AMOUNT_PARAM, 0);
        String commitRate = this.getParamTextValue(COMMIT_RATE_PARAM, 0);
        String demandRate = this.getParamTextValue(DEMAND_RATE_PARAM, 0);
        CLDBProto.UsageBillingResponse resp = null;
        CLDBProto.UsageBillingRequest.Builder req = CLDBProto.UsageBillingRequest.newBuilder();
        CLDBProto.UsageBillingInfo.Builder billingInfo = CLDBProto.UsageBillingInfo.newBuilder();
        billingInfo.setCommitAmountGb(commitAmountGb);
        billingInfo.setCommitRate(commitRate);
        billingInfo.setDemandRate(demandRate);
        req.setCreds(this.getUserCredentials());
        req.setLoad(false);
        req.setBillingInfo(billingInfo.build());
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageBillingProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageStatusResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.BillingServerProgramId.getNumber(), BillingProto.BillingProg.UsageBillingProc.getNumber(), (MessageLite)req.build(), CLDBProto.UsageStatusResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response, check cldb logs."));
                return;
            }
            resp = CLDBProto.UsageBillingResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        out.addMessage("Billing parameters updated successfully.");
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String cluster = null;
        Object credentials = null;
        String fileName = "NONE";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ExecuteRealCommand" + this.cliCommand.getCommandName()));
        }
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        boolean statusParamPresent = this.isParamPresent(STATUS_PARAM_NAME);
        boolean frequencyParamPresent = this.isParamPresent(FREQUENCY_PARAM_NAME);
        boolean urlParamPresent = this.isParamPresent(URL_PARAM_NAME);
        boolean modeParamPresent = this.isParamPresent(MODE_PARAM_NAME);
        boolean registerPresent = this.isParamPresent(REGISTER_PARAM_NAME);
        boolean renewPresent = this.isParamPresent(RENEW_PARAM_NAME);
        boolean billingPresent = this.isParamPresent(BILLING_PARAM_NAME);
        boolean keyFilePresent = this.isParamPresent(KEYFILE_PARAM_NAME);
        boolean keyPresent = this.isParamPresent(KEY_PARAM_NAME);
        Object outNode = null;
        boolean parseErr = false;
        CLDBProto.UsageEmailFrequency freq = CLDBProto.UsageEmailFrequency.EmailNone;
        String freqStr = "NONE";
        String keyFile = null;
        String key = null;
        if (registerPresent || renewPresent) {
            if (keyFilePresent && keyPresent) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Only one of keyFile or key params can be provided"));
                return output;
            }
            if (!keyFilePresent && !keyPresent) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "One of keyFile or key params must be provided"));
                return output;
            }
            if (keyFilePresent) {
                keyFile = this.getParamTextValue(KEYFILE_PARAM_NAME, 0);
            }
            if (keyPresent) {
                key = this.getParamTextValue(KEY_PARAM_NAME, 0);
            }
            this.registerActivationKey(out, keyFile, key, cluster);
            return output;
        }
        if (billingPresent) {
            if (statusParamPresent) {
                this.getBillingStatus(out, cluster);
                return output;
            }
            this.updateBillingParameters(out, cluster);
            return output;
        }
        if (frequencyParamPresent) {
            freqStr = this.getParamTextValue(FREQUENCY_PARAM_NAME, 0);
            if (freqStr.equalsIgnoreCase("none")) {
                freq = CLDBProto.UsageEmailFrequency.EmailNone;
            } else if (freqStr.equalsIgnoreCase("daily")) {
                freq = CLDBProto.UsageEmailFrequency.EmailDaily;
            } else if (freqStr.equalsIgnoreCase("weekly")) {
                freq = CLDBProto.UsageEmailFrequency.EmailWeekly;
            } else if (freqStr.equalsIgnoreCase("monthly")) {
                freq = CLDBProto.UsageEmailFrequency.EmailMonthly;
            } else {
                parseErr = true;
            }
        }
        try {
            if (statusParamPresent) {
                this.getUsageStatus(out, cluster);
            } else if (modeParamPresent) {
                this.updateExportMode(out, cluster);
            } else if (urlParamPresent) {
                this.updateUrl(out, cluster);
            } else if (frequencyParamPresent && !parseErr) {
                String custEmail = "testcustemail@gmail.com";
                if (this.isParamPresent(CUST_EMAIL_PARAM_NAME)) {
                    custEmail = this.getParamTextValue(CUST_EMAIL_PARAM_NAME, 0);
                }
                this.updateUsageEmailConfig(cluster, out, freq, custEmail);
            } else if (parseErr) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid email frequency parameter"));
            }
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception in usage export", (Throwable)e);
        }
        return output;
    }
}

