/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.DbCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.table.MfsInstanceStats;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cli.table.TabletStats;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.db.impl.IdCodec;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.util.Fids;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.ojai.Value;

public class DbRegionCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(DbRegionCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String INDEX_PARAM_NAME = "index";
    private static final String FID_PARAM_NAME = "fid";
    private static final String CTYPE_PARAM_NAME = "type";
    private static final String CTYPE_PARAM_DESC = "default|postsplit|sync|partitionSplit";
    private static final String NTHREADS_PARAM_NAME = "nthreads";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final int NUM_REGION_INFOS_PER_RPC = 25;
    private static final CLICommand splitCommand = new CLICommand("split", "usage: table region split -path <tablepath> -fid <fid>", DbRegionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage("table region split -path <tablepath> -fid <fid>");
    private static final CLICommand packCommand = new CLICommand("pack", "usage: table region pack -path <tablepath> -fid <fid>", DbRegionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"fid", (Object)new TextInputParameter("fid", "fid|all", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "default|postsplit|sync|partitionSplit", false, null).setInvisible(true)).put((Object)"nthreads", (Object)new IntegerInputParameter("nthreads", "nthreads", false, Integer.valueOf(16))).build(), null).setShortUsage("table region pack -path <tablepath> -fid <fid>");
    private static final CLICommand listCommand = new CLICommand("list", "usage: table region list -path <tablepath>", DbRegionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)"index", (Object)new TextInputParameter("index", "index name", false, null)).build(), null).setShortUsage("table region list -path <tablepath>");
    private static final CLICommand mergeCommand = new CLICommand("merge", "usage: table region merge -path <tablepath> -fid <fid>", DbRegionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"fid", (Object)new TextInputParameter("fid", "fid", true, null)).build(), null).setShortUsage("table region -path <tablepath> merge -fid <fid>");
    private static final CLICommand statCommand = new CLICommand("stat", "usage: table region stat -path <tablepath>", DbRegionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"index", (Object)new TextInputParameter("index", "index name", false, null)).build(), null).setShortUsage("table region stat -path <tablepath>");
    public static final CLICommand regionCommands = new CLICommand("region", "region [split|pack|merge|list|stat]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{splitCommand, packCommand, mergeCommand, listCommand, statCommand}).setShortUsage("table region [split|pack|merge|list|stat]");
    private static final BiMap<String, String> verboseToTerseMap = new ImmutableBiMap.Builder().put((Object)"startkey", (Object)"sk").put((Object)"endkey", (Object)"ek").put((Object)"numberofrowswithdelete", (Object)"nrd").put((Object)"primarymfs", (Object)"pn").put((Object)"secondarymfs", (Object)"sn").put((Object)"lastheartbeat", (Object)"lhb").put((Object)"physicalsize", (Object)"ps").put((Object)"logicalsize", (Object)"ls").put((Object)"numberofrows", (Object)"nr").put((Object)"fid", (Object)"fid").put((Object)"copypendingsize", (Object)"cps").put((Object)"numberofspills", (Object)"nsp").put((Object)"numberofsegments", (Object)"nsg").build();

    public DbRegionCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(splitCommand.getCommandName())) {
            this.splitRegion(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(packCommand.getCommandName())) {
            this.packRegion(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(mergeCommand.getCommandName())) {
            this.mergeRegion(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(listCommand.getCommandName())) {
            this.listRegions(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(statCommand.getCommandName())) {
            this.statRegions(out);
        }
        return output;
    }

    private void splitRegion(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String fidstr = this.getParamTextValue(FID_PARAM_NAME, 0);
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (!mfs.isTable(new Path(tablePath))) {
                        throw new CLIProcessingException("Path specified by '" + tablePath + "' does not exist or is not a table.");
                    }
                }
            };
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            manager.deleteIfNotExist(tablePath, mfs);
            return;
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            manager.deleteIfNotExist(tablePath, mfs);
            return;
        }
        try {
            mfs.splitTableRegion(new Path(tablePath), fidstr, false);
            manager.moveToTop(tablePath);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            manager.deleteIfNotExist(tablePath, mfs);
        }
    }

    private static CommandOutput.OutputHierarchy.OutputError invokePackRegionOnTabletFid(String tablePath, String fidstr, int ctype) throws CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        try {
            mfs.packTableRegion(new Path(tablePath), fidstr, ctype);
        }
        catch (IOException e) {
            return new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage());
        }
        return new CommandOutput.OutputHierarchy.OutputError(0, null);
    }

    private static List<Dbserver.TabletDesc> getAllTabletDescriptors(String tablePath, String username, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        int start = 0;
        int limit = Integer.MAX_VALUE;
        TabletStats tabletStats = new TabletStats(tablePath, username);
        List<Dbserver.TabletDesc> tablets = tabletStats.getTablets(out, start, limit);
        return tablets;
    }

    public static CommandOutput.OutputHierarchy.OutputError packAllRegionsOfTable(final String tablePath, final int ctype, int nthreads, String username) throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        List<Dbserver.TabletDesc> tablets = DbRegionCommands.getAllTabletDescriptors(tablePath, username, out);
        if (tablets == null) {
            if (out.getOutputErrors() != null && out.getOutputErrors().size() > 1) {
                return (CommandOutput.OutputHierarchy.OutputError)out.getOutputErrors().get(0);
            }
            return new CommandOutput.OutputHierarchy.OutputError(10003, "Error fetching regions for " + tablePath);
        }
        ExecutorService executor = Executors.newFixedThreadPool(nthreads);
        ArrayList<Future<CommandOutput.OutputHierarchy.OutputError>> fObj = new ArrayList<Future<CommandOutput.OutputHierarchy.OutputError>>();
        for (Dbserver.TabletDesc tablet : tablets) {
            final String fid = MapRCliUtil.getFidAsString(tablet.getFid());
            Callable<CommandOutput.OutputHierarchy.OutputError> packCommand = new Callable<CommandOutput.OutputHierarchy.OutputError>(){

                @Override
                public CommandOutput.OutputHierarchy.OutputError call() throws CLIProcessingException {
                    CommandOutput.OutputHierarchy.OutputError retval = null;
                    retval = DbRegionCommands.invokePackRegionOnTabletFid(tablePath, fid, ctype);
                    return retval;
                }
            };
            Future<CommandOutput.OutputHierarchy.OutputError> fRet = executor.submit(packCommand);
            fObj.add(fRet);
        }
        int fObjSize = fObj.size();
        ArrayList<CommandOutput.OutputHierarchy.OutputError> errorCodes = new ArrayList<CommandOutput.OutputHierarchy.OutputError>();
        try {
            for (int i = 0; i < fObjSize; ++i) {
                CommandOutput.OutputHierarchy.OutputError retval = (CommandOutput.OutputHierarchy.OutputError)((Future)fObj.get(i)).get();
                if (retval.getErrorCode() == 0) continue;
                errorCodes.add(retval);
            }
        }
        catch (Exception e) {
            return new CommandOutput.OutputHierarchy.OutputError(10003, " wait for threadpool to finish failed " + e.getMessage());
        }
        executor.shutdown();
        if (errorCodes.isEmpty()) {
            return null;
        }
        return (CommandOutput.OutputHierarchy.OutputError)errorCodes.get(0);
    }

    private void packRegion(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String fidstr = null;
        fidstr = this.getParamTextValue(FID_PARAM_NAME, 0);
        int ctype = Dbserver.ForcedCompactionType.ForcedCompactionDefault.getNumber();
        if (this.isParamPresent(CTYPE_PARAM_NAME)) {
            String ctypeStr = this.getParamTextValue(CTYPE_PARAM_NAME, 0);
            if (ctypeStr.equalsIgnoreCase("default")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionDefault.getNumber();
            } else if (ctypeStr.equalsIgnoreCase("postSplit")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionPostSplit.getNumber();
            } else if (ctypeStr.equalsIgnoreCase("sync")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionSync.getNumber();
            } else if (ctypeStr.equalsIgnoreCase("partitionSplit")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionPartitionSplit.getNumber();
            } else if (ctypeStr.equalsIgnoreCase("ttl")) {
                ctype = Dbserver.ForcedCompactionType.ForcedCompactionTTL.getNumber();
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "unknown type " + ctypeStr));
                return;
            }
        }
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (!mfs.isTable(new Path(tablePath))) {
                        throw new CLIProcessingException("Path specified by '" + tablePath + "' does not exist or is not a table.");
                    }
                }
            };
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            return;
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return;
        }
        manager.moveToTop(tablePath);
        CommandOutput.OutputHierarchy.OutputError err = null;
        if (fidstr.equals("all")) {
            int nthreads = this.getParamIntValue(NTHREADS_PARAM_NAME, 0);
            err = DbRegionCommands.packAllRegionsOfTable(tablePath, ctype, nthreads, this.getUserLoginId());
        } else {
            err = DbRegionCommands.invokePackRegionOnTabletFid(tablePath, fidstr, ctype);
        }
        if (err != null && err.getErrorCode() != 0) {
            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            manager.deleteIfNotExist(tablePath, mfs);
            out.addError(err);
        }
    }

    private boolean showColumn(Set<String> columns, String verboseName) {
        if (columns == null) {
            return false;
        }
        String terseName = (String)verboseToTerseMap.get((Object)verboseName);
        return columns.contains("all") || columns.contains(verboseName) || columns.contains(terseName);
    }

    private void listRegions(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String path = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        int start = this.getParamIntValue(START_PARAM_NAME, 0);
        int limit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
        boolean wantIndexTablets = this.isParamPresent(INDEX_PARAM_NAME);
        String indexName = wantIndexTablets ? this.getParamTextValue(INDEX_PARAM_NAME, 0) : null;
        ArrayList<MfsInstanceStats.TabletStatInfo> tsInfoList = new ArrayList<MfsInstanceStats.TabletStatInfo>();
        this.getRegionStats(out, path, start, limit, wantIndexTablets, indexName, tsInfoList);
        if (out.getOutputErrors() != null && out.getOutputErrors().size() > 0) {
            return;
        }
        if (tsInfoList.size() <= 0) {
            LOG.info((Object)("In listRegions, getRegionStats found 0 tablet stats for path " + path));
            return;
        }
        String columnsString = this.getParamTextValue(COLUMNS_PARAM_NAME, 0);
        HashSet<String> columns = null;
        if (columnsString != null) {
            columns = new HashSet<String>(Arrays.asList(columnsString.split(",")));
        }
        for (String columnName : columns) {
            if (columns.size() == 1 && columnName.equals("all")) break;
            if (verboseToTerseMap.keySet().contains(columnName) || verboseToTerseMap.entrySet().contains(columnName)) continue;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid column name '" + columnName + "'"));
            return;
        }
        for (MfsInstanceStats.TabletStatInfo tsInfo : tsInfoList) {
            CommandOutput.OutputHierarchy.OutputNode tabletNode = new CommandOutput.OutputHierarchy.OutputNode();
            if (this.showColumn(columns, "primarymfs")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("primarymfs"), (Object)tsInfo.getPrimaryMfs().toString()));
            }
            String secondarymfs = this.mfsListToString(tsInfo.getSecondaryMfsList());
            if (this.showColumn(columns, "secondarymfs")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("secondarymfs"), (Object)secondarymfs));
            }
            boolean isJson = this.isJsonTable(path);
            byte[] startKey = tsInfo.getStartKey();
            byte[] endKey = tsInfo.getEndKey();
            String startKeyStr = "-INFINITY";
            String endKeyStr = "INFINITY";
            if (startKey.length != 0) {
                String string = startKeyStr = isJson ? IdCodec.asString((Value)IdCodec.decode((byte[])startKey)) : Bytes.toStringBinary((byte[])startKey);
            }
            if (endKey.length != 0) {
                String string = endKeyStr = isJson ? IdCodec.asString((Value)IdCodec.decode((byte[])endKey)) : Bytes.toStringBinary((byte[])endKey);
            }
            if (this.showColumn(columns, "startkey")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("startkey"), (Object)startKeyStr));
            }
            if (this.showColumn(columns, "endkey")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("endkey"), (Object)endKeyStr));
            }
            if (this.showColumn(columns, "lastheartbeat")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("lastheartbeat"), tsInfo.getLastheartbeat()));
            }
            if (this.showColumn(columns, FID_PARAM_NAME)) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(FID_PARAM_NAME), (Object)MapRCliUtil.getFidAsString(tsInfo.getFid())));
            }
            if (this.showColumn(columns, "logicalsize")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("logicalsize"), tsInfo.getLogicalSize()));
            }
            if (this.showColumn(columns, "physicalsize")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("physicalsize"), tsInfo.getPhysicalSize()));
            }
            if (this.showColumn(columns, "copypendingsize") && tsInfo.getHasCopyPendingSize()) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("copypendingsize"), tsInfo.getCopypendingSize()));
            }
            if (this.showColumn(columns, "numberofrows")) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("numberofrows"), tsInfo.getNumRows()));
            }
            if (this.showColumn(columns, "numberofrowswithdelete") && tsInfo.getHasNumRowsWithDelete()) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("numberofrowswithdelete"), tsInfo.getNumRowsWithDelete()));
            }
            if (this.showColumn(columns, "numberofspills") && tsInfo.getHasNumSpills()) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("numberofspills"), tsInfo.getNumSpills()));
            }
            if (this.showColumn(columns, "numberofsegments") && tsInfo.getHasNumSegments()) {
                tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("numberofsegments"), tsInfo.getNumSegments()));
            }
            out.addNode(tabletNode);
        }
    }

    private void statRegions(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String path = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        int start = 0;
        int limit = Integer.MAX_VALUE;
        boolean wantIndexTablets = this.isParamPresent(INDEX_PARAM_NAME);
        String indexName = wantIndexTablets ? this.getParamTextValue(INDEX_PARAM_NAME, 0) : null;
        ArrayList<MfsInstanceStats.TabletStatInfo> tsInfoList = new ArrayList<MfsInstanceStats.TabletStatInfo>();
        this.getRegionStats(out, path, start, limit, wantIndexTablets, indexName, tsInfoList);
        if (out.getOutputErrors() != null && out.getOutputErrors().size() > 0) {
            return;
        }
        if (tsInfoList.size() <= 0) {
            LOG.info((Object)("In statRegions, getRegionStats find 0 tablet stats for path " + path));
            return;
        }
        HashSet<String> allNodeSet = new HashSet<String>();
        HashSet<String> allMfsSet = new HashSet<String>();
        HashSet<String> primaryNodeSet = new HashSet<String>();
        HashSet<String> primaryMfsSet = new HashSet<String>();
        HashSet<String> secondaryNodeSet = new HashSet<String>();
        HashSet<String> secondaryMfsSet = new HashSet<String>();
        HashMap<String, MfsInstanceStats> mfsStatsMap = new HashMap<String, MfsInstanceStats>();
        for (MfsInstanceStats.TabletStatInfo tsInfo : tsInfoList) {
            MfsInstanceStats.MfsInstanceName primaryMfs = tsInfo.getPrimaryMfs();
            if (primaryMfs.isValid()) {
                MfsInstanceStats mfsStats = (MfsInstanceStats)mfsStatsMap.get(primaryMfs.toString());
                if (mfsStats == null) {
                    mfsStats = new MfsInstanceStats(primaryMfs);
                }
                mfsStats.addTabletDesc(out, true, tsInfo);
                mfsStatsMap.put(primaryMfs.toString(), mfsStats);
                allNodeSet.add(primaryMfs.getNode());
                primaryNodeSet.add(primaryMfs.getNode());
                allMfsSet.add(primaryMfs.toString());
                primaryMfsSet.add(primaryMfs.toString());
            }
            List<MfsInstanceStats.MfsInstanceName> secondarMfsList = tsInfo.getSecondaryMfsList();
            for (MfsInstanceStats.MfsInstanceName secondaryMfs : secondarMfsList) {
                if (!secondaryMfs.isValid()) continue;
                MfsInstanceStats mfsStats = (MfsInstanceStats)mfsStatsMap.get(secondaryMfs.toString());
                if (mfsStats == null) {
                    mfsStats = new MfsInstanceStats(secondaryMfs);
                }
                mfsStats.addTabletDesc(out, false, tsInfo);
                mfsStatsMap.put(secondaryMfs.toString(), mfsStats);
                allNodeSet.add(secondaryMfs.getNode());
                secondaryNodeSet.add(secondaryMfs.getNode());
                allMfsSet.add(secondaryMfs.toString());
                secondaryMfsSet.add(secondaryMfs.toString());
            }
        }
        long totalPrimaryTablets = 0L;
        long minPrimaryTabletsPerMfs = Long.MAX_VALUE;
        long maxPrimaryTabletsPerMfs = 0L;
        long totalPrimaryLogicalSize = 0L;
        long minPrimaryLogicalSizePerMfs = Long.MAX_VALUE;
        long maxPrimaryLogicalSizePerMfs = 0L;
        long totalPrimaryPhysicalSize = 0L;
        long minPrimaryPhysicalSizePerMfs = Long.MAX_VALUE;
        long maxPrimaryPhysicalSizePerMfs = 0L;
        long totalSecondaryTablets = 0L;
        long minSecondaryTabletsPerMfs = Long.MAX_VALUE;
        long maxSecondaryTabletsPerMfs = 0L;
        long totalSecondaryLogicalSize = 0L;
        long minSecondaryLogicalSizePerMfs = Long.MAX_VALUE;
        long maxSecondaryLogicalSizePerMfs = 0L;
        long totalSecondaryPhysicalSize = 0L;
        long minSecondaryPhysicalSizePerMfs = Long.MAX_VALUE;
        long maxSecondaryPhysicalSizePerMfs = 0L;
        ArrayList<CommandOutput.OutputHierarchy.OutputNode> mfsInsOutputNodeList = new ArrayList<CommandOutput.OutputHierarchy.OutputNode>();
        for (Map.Entry pair : mfsStatsMap.entrySet()) {
            CommandOutput.OutputHierarchy.OutputNode mfsInsNode = new CommandOutput.OutputHierarchy.OutputNode("mfsInstances");
            mfsInsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("instanceId", pair.getKey()));
            MfsInstanceStats mfsIns = (MfsInstanceStats)pair.getValue();
            totalPrimaryTablets += (long)mfsIns.numOfPrimaryTablets();
            totalPrimaryLogicalSize += mfsIns.totalPrimaryTabletsLogicalSize();
            totalPrimaryPhysicalSize += mfsIns.totalPrimaryTabletsPhysicalSize();
            if ((long)mfsIns.numOfPrimaryTablets() < minPrimaryTabletsPerMfs) {
                minPrimaryTabletsPerMfs = mfsIns.numOfPrimaryTablets();
            }
            if ((long)mfsIns.numOfPrimaryTablets() > maxPrimaryTabletsPerMfs) {
                maxPrimaryTabletsPerMfs = mfsIns.numOfPrimaryTablets();
            }
            if (mfsIns.totalPrimaryTabletsLogicalSize() < minPrimaryLogicalSizePerMfs) {
                minPrimaryLogicalSizePerMfs = mfsIns.totalPrimaryTabletsLogicalSize();
            }
            if (mfsIns.totalPrimaryTabletsLogicalSize() > maxPrimaryLogicalSizePerMfs) {
                maxPrimaryLogicalSizePerMfs = mfsIns.totalPrimaryTabletsLogicalSize();
            }
            if (mfsIns.totalPrimaryTabletsPhysicalSize() < minPrimaryPhysicalSizePerMfs) {
                minPrimaryPhysicalSizePerMfs = mfsIns.totalPrimaryTabletsPhysicalSize();
            }
            if (mfsIns.totalPrimaryTabletsPhysicalSize() > maxPrimaryPhysicalSizePerMfs) {
                maxPrimaryPhysicalSizePerMfs = mfsIns.totalPrimaryTabletsPhysicalSize();
            }
            totalSecondaryTablets += (long)mfsIns.numOfSecondaryTablets();
            totalSecondaryLogicalSize += mfsIns.totalSecondaryTabletsLogicalSize();
            totalSecondaryPhysicalSize += mfsIns.totalSecondaryTabletsPhysicalSize();
            if ((long)mfsIns.numOfSecondaryTablets() < minSecondaryTabletsPerMfs) {
                minSecondaryTabletsPerMfs = mfsIns.numOfSecondaryTablets();
            }
            if ((long)mfsIns.numOfSecondaryTablets() > maxSecondaryTabletsPerMfs) {
                maxSecondaryTabletsPerMfs = mfsIns.numOfSecondaryTablets();
            }
            if (mfsIns.totalSecondaryTabletsLogicalSize() < minSecondaryLogicalSizePerMfs) {
                minSecondaryLogicalSizePerMfs = mfsIns.totalSecondaryTabletsLogicalSize();
            }
            if (mfsIns.totalSecondaryTabletsLogicalSize() > maxSecondaryLogicalSizePerMfs) {
                maxSecondaryLogicalSizePerMfs = mfsIns.totalSecondaryTabletsLogicalSize();
            }
            if (mfsIns.totalSecondaryTabletsPhysicalSize() < minSecondaryPhysicalSizePerMfs) {
                minSecondaryPhysicalSizePerMfs = mfsIns.totalSecondaryTabletsPhysicalSize();
            }
            if (mfsIns.totalSecondaryTabletsPhysicalSize() > maxSecondaryPhysicalSizePerMfs) {
                maxSecondaryPhysicalSizePerMfs = mfsIns.totalSecondaryTabletsPhysicalSize();
            }
            mfsInsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalPrimaryTablets", mfsIns.numOfPrimaryTablets()));
            mfsInsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalSecondaryTablets", mfsIns.numOfSecondaryTablets()));
            mfsInsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalPrimaryTabletsLogicalSize", mfsIns.totalPrimaryTabletsLogicalSize()));
            mfsInsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalSecondaryTabletsLogicalSize", mfsIns.totalSecondaryTabletsLogicalSize()));
            mfsInsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalPrimaryTabletsPhysicalSize", mfsIns.totalPrimaryTabletsPhysicalSize()));
            mfsInsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalSecondaryTabletsPhysicalSize", mfsIns.totalSecondaryTabletsPhysicalSize()));
            mfsInsOutputNodeList.add(mfsInsNode);
        }
        int totalMfsInstances = allMfsSet.size();
        if (totalMfsInstances == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "no mfs instances found for path " + path));
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode tabletNode = new CommandOutput.OutputHierarchy.OutputNode();
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalNodes"), allNodeSet.size()));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalNodesWithPrimaryTablets"), primaryNodeSet.size()));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalNodesWIthSecondaryTablets"), secondaryNodeSet.size()));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalMfsInstances"), totalMfsInstances));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalMfsInstancesWithPrimaryTablets"), primaryMfsSet.size()));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalMfsInstancesWithSecondaryTablets"), secondaryMfsSet.size()));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalTablets"), totalPrimaryTablets + totalSecondaryTablets));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalLogicalSize"), totalPrimaryLogicalSize + totalSecondaryLogicalSize));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalPhysicalSize"), totalPrimaryPhysicalSize + totalSecondaryPhysicalSize));
        if (totalPrimaryTablets == 0L) {
            minPrimaryTabletsPerMfs = 0L;
            maxPrimaryTabletsPerMfs = 0L;
        }
        float avgFloat = (float)totalPrimaryTablets / (float)totalMfsInstances;
        String avgNumStr = String.format("%.2f", Float.valueOf(avgFloat));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalPrimaryTablets"), totalPrimaryTablets));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("avgPrimaryTabletsPerMfsInstance"), (Object)avgNumStr));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("minPrimaryTabletsPerMfsInstance"), minPrimaryTabletsPerMfs));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("maxPrimaryTabletsPerMfsInstance"), maxPrimaryTabletsPerMfs));
        if (totalSecondaryTablets == 0L) {
            minSecondaryTabletsPerMfs = 0L;
            maxSecondaryTabletsPerMfs = 0L;
        }
        avgFloat = (float)totalSecondaryTablets / (float)totalMfsInstances;
        avgNumStr = String.format("%.2f", Float.valueOf(avgFloat));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalSecondaryTablets"), totalSecondaryTablets));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("avgSecondaryTabletsPerMfsInstance"), (Object)avgNumStr));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("minSecondaryTabletsPerMfsInstance"), minSecondaryTabletsPerMfs));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("maxSecondaryTabletsPerMfsInstance"), maxSecondaryTabletsPerMfs));
        if (totalPrimaryLogicalSize == 0L) {
            minPrimaryLogicalSizePerMfs = 0L;
            maxPrimaryLogicalSizePerMfs = 0L;
        }
        long avgLong = totalPrimaryLogicalSize / (long)totalMfsInstances;
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalPrimaryLogicalSize"), totalPrimaryLogicalSize));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("avgPrimaryLogicalSizePerMfsInstance"), avgLong));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("minPrimaryLogicalSizePerMfsInstance"), minPrimaryLogicalSizePerMfs));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("maxPrimaryLogicalSizePerMfsInstance"), maxPrimaryLogicalSizePerMfs));
        if (totalSecondaryLogicalSize == 0L) {
            minSecondaryLogicalSizePerMfs = 0L;
            maxSecondaryLogicalSizePerMfs = 0L;
        }
        avgLong = totalSecondaryLogicalSize / (long)totalMfsInstances;
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalSecondaryLogicalSize"), totalSecondaryLogicalSize));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("avgSecondaryLogicalSizePerMfsInstance"), avgLong));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("minSecondaryLogicalSizePerMfsInstance"), minSecondaryLogicalSizePerMfs));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("maxSecondaryLogicalSizePerMfsInstance"), maxSecondaryLogicalSizePerMfs));
        if (totalPrimaryPhysicalSize == 0L) {
            minPrimaryPhysicalSizePerMfs = 0L;
            maxPrimaryPhysicalSizePerMfs = 0L;
        }
        avgLong = totalPrimaryPhysicalSize / (long)totalMfsInstances;
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalPrimaryPhysicalSize"), totalPrimaryPhysicalSize));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("avgPrimaryPhysicalSizePerMfsInstance"), avgLong));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("minPrimaryPhysicalSizePerMfsInstance"), minPrimaryPhysicalSizePerMfs));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("maxPrimaryPhysicalSizePerMfsInstance"), maxPrimaryPhysicalSizePerMfs));
        if (totalSecondaryPhysicalSize == 0L) {
            minSecondaryPhysicalSizePerMfs = 0L;
            maxSecondaryPhysicalSizePerMfs = 0L;
        }
        avgLong = totalSecondaryPhysicalSize / (long)totalMfsInstances;
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalSecondaryPhysicalSize"), totalSecondaryPhysicalSize));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("avgSecondaryPhysicalSizePerMfsInstance"), avgLong));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("minSecondaryPhysicalSizePerMfsInstance"), minSecondaryPhysicalSizePerMfs));
        tabletNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("maxSecondaryPhysicalSizePerMfsInstance"), maxSecondaryPhysicalSizePerMfs));
        for (CommandOutput.OutputHierarchy.OutputNode mfsInsNode : mfsInsOutputNodeList) {
            tabletNode.addChild(mfsInsNode);
        }
        out.addNode(tabletNode);
    }

    private void getRegionStats(CommandOutput.OutputHierarchy out, final String path, int start, int limit, boolean wantIndexTablets, String indexName, List<MfsInstanceStats.TabletStatInfo> tsInfoList) throws CLIProcessingException {
        TabletStats tabletStats;
        List<Dbserver.TabletDesc> tablets;
        LOG.debug((Object)("getRegionStats for path:" + path + ", start:" + start + ", limit:" + limit));
        final ArrayList rlist = new ArrayList();
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (!mfs.isTable(new Path(path))) {
                        throw new CLIProcessingException("Path specified by '" + path + "' does not exist or is not a table.");
                    }
                }
            };
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            return;
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return;
        }
        final Path tablePath = new Path(path);
        boolean isJson = this.isJsonTable(path);
        String indexFid = null;
        if (wantIndexTablets) {
            if (!isJson) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, tablePath + " is not a json table. table region list -index is not supported."));
                return;
            }
            try {
                new FileclientRun(this.getUserLoginId()){

                    @Override
                    public void runAsProxyUser() throws CLIProcessingException {
                        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                        try {
                            Dbserver.TableReplicaListResponse resp = mfs.listTableIndexes(tablePath, true, true, true);
                            rlist.add(resp);
                        }
                        catch (IOException e) {
                            throw new CLIProcessingException(e.getMessage());
                        }
                    }
                };
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
            Dbserver.TableReplicaListResponse resp = (Dbserver.TableReplicaListResponse)rlist.get(0);
            for (Dbserver.TableReplicaDesc rd : resp.getReplicasList()) {
                Dbserver.SIndexInfo siInfo = rd.getSiInfo();
                if (!siInfo.getIndexName().equals(indexName)) continue;
                indexFid = Fids.fidToString((Common.FidMsg)siInfo.getIndexFid());
                break;
            }
            if (indexFid == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, tablePath + " does not have an index named '" + indexName + "'"));
                return;
            }
        }
        if ((tablets = (tabletStats = new TabletStats(path, this.getUserLoginId())).getTablets(out, start, limit, indexFid)) == null) {
            return;
        }
        Map<Integer, CLDBProto.TabletInfo> cidMap = this.getTabletsInfo(out, tablets);
        for (Dbserver.TabletDesc tablet : tablets) {
            CLDBProto.TabletInfo tabletInfo = cidMap.get(tablet.getFid().getCid());
            List ipList = tabletInfo.getMaster().getIpsList();
            MfsInstanceStats.MfsInstanceName primaryMfs = null;
            primaryMfs = ipList == null || ipList.isEmpty() ? new MfsInstanceStats.MfsInstanceName("(No hosts found)", -1) : new MfsInstanceStats.MfsInstanceName(((Common.IPAddress)ipList.get(0)).getHostname(), ((Common.IPAddress)ipList.get(0)).getPort());
            List<MfsInstanceStats.MfsInstanceName> secondaryMfsList = this.getSecondaryMfsList(tabletInfo);
            byte[] startKey = tablet.getStartKey().toByteArray();
            byte[] endKey = tablet.getEndKey().toByteArray();
            int lastheartbeat = tabletInfo.getMastersLastHBSec();
            Common.FidMsg fid = tablet.getFid();
            long logicalsize = 0L;
            long physicalsize = 0L;
            boolean hascopypendingsize = false;
            long copypendingsize = 0L;
            long numberofrows = 0L;
            boolean hasnumberofrowswithdelete = false;
            long numberofrowswithdelete = 0L;
            boolean hasnumberofspills = false;
            long numberofspills = 0L;
            boolean hasnumberofsegments = false;
            long numberofsegments = 0L;
            try {
                Dbserver.TabletStatResponse tsr = tabletStats.getTabletStatResponse(tablet);
                if (tsr != null && tsr.hasUsage()) {
                    Dbserver.SpaceUsage su = tsr.getUsage();
                    long blockSize = 8192L;
                    logicalsize = su.getNumLogicalBlocks() * blockSize;
                    physicalsize = su.getNumPhysicalBlocks() * blockSize;
                    hascopypendingsize = su.hasNumRemoteBlocks();
                    if (hascopypendingsize) {
                        copypendingsize = su.getNumRemoteBlocks() * blockSize;
                    }
                    numberofrows = su.getNumRows();
                    hasnumberofrowswithdelete = su.hasNumRowsWithDelete();
                    if (hasnumberofrowswithdelete) {
                        numberofrowswithdelete = su.getNumRowsWithDelete();
                    }
                    if (hasnumberofspills = su.hasNumSpills()) {
                        numberofspills = su.getNumSpills();
                    }
                    if (hasnumberofsegments = su.hasNumSegments()) {
                        numberofsegments = su.getNumSegments();
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error fetching tablet stats for fid: " + MapRCliUtil.getFidAsString(tablet.getFid())), (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to fetch tablet stats for fid: " + MapRCliUtil.getFidAsString(tablet.getFid())));
            }
            MfsInstanceStats.TabletStatInfo tsInfo = new MfsInstanceStats.TabletStatInfo(startKey, endKey, lastheartbeat, fid, primaryMfs, secondaryMfsList, logicalsize, physicalsize, hascopypendingsize, copypendingsize, numberofrows, hasnumberofrowswithdelete, numberofrowswithdelete, hasnumberofspills, numberofspills, hasnumberofsegments, numberofsegments);
            tsInfoList.add(tsInfo);
        }
        manager.moveToTop(path);
    }

    private boolean isJsonTable(String path) throws CLIProcessingException {
        try {
            return MapRCliUtil.getMapRFileSystem().getTableProperties(new Path(path)).getAttr().getJson();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    private Map<Integer, CLDBProto.TabletInfo> getTabletsInfo(CommandOutput.OutputHierarchy out, List<Dbserver.TabletDesc> tablets) throws CLIProcessingException {
        CLDBProto.TabletInfoRequest.Builder tabletInfoReqBuilder;
        HashSet cidSet = Sets.newHashSet();
        for (Dbserver.TabletDesc tablet : tablets) {
            cidSet.add(tablet.getFid().getCid());
        }
        HashMap cidToTabletInfoMap = Maps.newHashMap();
        int from = 0;
        int to = 25;
        ArrayList cidList = Lists.newArrayList((Iterable)cidSet);
        while (to < cidList.size()) {
            tabletInfoReqBuilder = CLDBProto.TabletInfoRequest.newBuilder().setCreds(this.getUserCredentials());
            tabletInfoReqBuilder.addAllContainerId(cidList.subList(from, to));
            this.fetchTabletsInfoFromCLDB(tabletInfoReqBuilder, out, cidToTabletInfoMap);
            if (!out.getOutputErrors().isEmpty()) {
                return cidToTabletInfoMap;
            }
            from = to;
            to = from + 25;
        }
        tabletInfoReqBuilder = CLDBProto.TabletInfoRequest.newBuilder().setCreds(this.getUserCredentials());
        tabletInfoReqBuilder.addAllContainerId(cidList.subList(from, cidList.size()));
        this.fetchTabletsInfoFromCLDB(tabletInfoReqBuilder, out, cidToTabletInfoMap);
        return cidToTabletInfoMap;
    }

    private void fetchTabletsInfoFromCLDB(CLDBProto.TabletInfoRequest.Builder request, CommandOutput.OutputHierarchy out, Map<Integer, CLDBProto.TabletInfo> results) throws CLIProcessingException {
        try {
            String cluster = MapRCliUtil.extractClusterNameFromFullyQualifiedPath(this.getParamTextValue(PATH_PARAM_NAME, 0));
            byte[] replyData = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TabletInfoProc.getNumber(), (MessageLite)request.build(), CLDBProto.TabletInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TabletInfoProc.getNumber(), (MessageLite)request.build(), CLDBProto.TabletInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Could not retrieve the list of regions. Reason: Could not connect to the CLDB service"));
                return;
            }
            CLDBProto.TabletInfoResponse resp = CLDBProto.TabletInfoResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Could not retrieve the list of regions. Reason: Region lookup failed. Error: " + Errno.toString((int)resp.getStatus())));
                return;
            }
            List tabletsInfoList = resp.getTabletsList();
            if (tabletsInfoList.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Could not retrieve the list of regions. Reason: Region info response did not contain regions information in it."));
                return;
            }
            for (CLDBProto.TabletInfo tabletInfo : tabletsInfoList) {
                results.put(tabletInfo.getContainerId(), tabletInfo);
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
    }

    private String getSecondaryMfs(CLDBProto.TabletInfo tablet) {
        StringBuilder secondaryMfsBuilder = new StringBuilder();
        boolean first = true;
        for (Common.Server secondaryServers : tablet.getReplicasList()) {
            List secondaryIpsList = secondaryServers.getIpsList();
            if (secondaryIpsList == null || secondaryIpsList.isEmpty() || Util.compareIPAddress((Common.IPAddress)tablet.getMaster().getIps(0), (Common.IPAddress)secondaryServers.getIps(0))) continue;
            if (!first) {
                secondaryMfsBuilder.append(", ");
            }
            Object mfs = null;
            if (secondaryServers.hasHostname()) {
                mfs = secondaryServers.getHostname() + ":" + secondaryServers.getIps(0).getPort();
            }
            if (mfs == null || ((String)mfs).isEmpty()) {
                mfs = secondaryServers.getIps(0).getHostname() + ":" + secondaryServers.getIps(0).getPort();
            }
            secondaryMfsBuilder.append((String)mfs);
            first = false;
        }
        return secondaryMfsBuilder.toString();
    }

    private String mfsListToString(List<MfsInstanceStats.MfsInstanceName> mfsInsList) {
        StringBuilder mfsStrListBuilder = new StringBuilder();
        boolean first = true;
        for (MfsInstanceStats.MfsInstanceName mfsIns : mfsInsList) {
            if (!first) {
                mfsStrListBuilder.append(", ");
            }
            String mfsStr = mfsIns.toString();
            mfsStrListBuilder.append(mfsStr);
            first = false;
        }
        return mfsStrListBuilder.toString();
    }

    private List<MfsInstanceStats.MfsInstanceName> getSecondaryMfsList(CLDBProto.TabletInfo tablet) {
        ArrayList<MfsInstanceStats.MfsInstanceName> retList = new ArrayList<MfsInstanceStats.MfsInstanceName>();
        for (Common.Server secondaryServers : tablet.getReplicasList()) {
            List secondaryIpsList = secondaryServers.getIpsList();
            if (secondaryIpsList == null || secondaryIpsList.isEmpty() || Util.compareIPAddress((Common.IPAddress)tablet.getMaster().getIps(0), (Common.IPAddress)secondaryServers.getIps(0))) continue;
            MfsInstanceStats.MfsInstanceName mfsInsName = null;
            mfsInsName = secondaryServers.hasHostname() ? new MfsInstanceStats.MfsInstanceName(secondaryServers.getHostname(), secondaryServers.getIps(0).getPort()) : new MfsInstanceStats.MfsInstanceName(secondaryServers.getIps(0).getHostname(), secondaryServers.getIps(0).getPort());
            retList.add(mfsInsName);
        }
        return retList;
    }

    private String getOutputFieldName(String verboseName) throws CLIProcessingException {
        return "terse".equals(this.getParamTextValue(OUTPUT_PARAM_NAME, 0)) ? (String)verboseToTerseMap.get((Object)verboseName) : verboseName;
    }

    private void mergeRegion(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String fidstr = this.getParamTextValue(FID_PARAM_NAME, 0);
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (!mfs.isTable(new Path(tablePath))) {
                        throw new CLIProcessingException("Path specified by '" + tablePath + "' does not exist or is not a table.");
                    }
                }
            };
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            manager.deleteIfNotExist(tablePath, mfs);
            return;
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            manager.deleteIfNotExist(tablePath, mfs);
            return;
        }
        try {
            mfs.mergeTableRegion(new Path(tablePath), fidstr);
            manager.moveToTop(tablePath);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            manager.deleteIfNotExist(tablePath, mfs);
        }
    }
}

