/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserSessionCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(UserSessionCommands.class);
    private static final int NUM_ENTRIES_PER_RPC = 100;
    public static final String COMMAND_APIS_USERSESSION_GET = "get";
    public static final String COMMAND_APIS_USERSESSION_ADD = "add";
    public static final String COMMAND_APIS_USERSESSION_UPDATE = "update";
    public static final String COMMAND_APIS_USERSESSION_REMOVE = "remove";
    public static final String COMMAND_APIS_USERSESSION_REMOVEALL = "removeall";
    public static final String COMMAND_APIS_USERSESSION_LIST = "list";
    public static final String PARAM_UID = "uid";
    public static final String PARAM_SESSIONID = "sessionid";
    public static final String PARAM_APISERVER = "apiserver";
    public static final String PARAM_TTL = "ttl";
    public static final String PARAM_COLUMNS = "columns";
    public static final String PARAM_OUTPUT = "output";
    public static final String PARAM_START = "start";
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_FILTER = "filter";
    public static final String APIS_USERSESSION_CMD_USAGE = "usersession [get|add|update|remove|removeall]";
    public static final String UserSessionGetUsage = "usersession get -uid <user-id> ";
    public static final String UserSessionAddUsage = "usersession add -uid <user-id> -sessionid <session-id> -apiserver <hostname fqdn> -ttl <ttl in seconds> ";
    public static final String UserSessionUpdateUsage = "usersession update -uid <user-id> -sessionid <session-id> -apiserver <hostname fqdn> -ttl <ttl in seconds> ";
    public static final String UserSessionRemoveUsage = "usersession remove -sessionid <session-id> -uid <user-id> -apiserver <hostname fqdn> ";
    public static final String UserSessionRemoveAllUsage = "usersession removeall -apiserver <hostname fqdn>";
    public static final String UserSessionListUsage = "usersession list [-filter <filters>]";
    public static final CLICommand UserSessionGetCommand = new CLICommand("get", "usersession get -uid <user-id> ", UserSessionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"uid", (Object)new TextInputParameter("uid", "user-id", true, null)).build(), null).setShortUsage("usersession get -uid <user-id> ");
    public static final CLICommand UserSessionAddCommand = new CLICommand("add", "usersession add -uid <user-id> -sessionid <session-id> -apiserver <hostname fqdn> -ttl <ttl in seconds> ", UserSessionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"uid", (Object)new TextInputParameter("uid", "user-id", true, null)).put((Object)"sessionid", (Object)new TextInputParameter("sessionid", "session-id", true, null)).put((Object)"apiserver", (Object)new TextInputParameter("apiserver", "apiserver fqdn hostname", true, null)).put((Object)"ttl", (Object)new IntegerInputParameter("ttl", "Time to Live in seconds", true, null)).build(), null).setShortUsage("usersession add -uid <user-id> -sessionid <session-id> -apiserver <hostname fqdn> -ttl <ttl in seconds> ");
    public static final CLICommand UserSessionUpdateCommand = new CLICommand("update", "usersession update -uid <user-id> -sessionid <session-id> -apiserver <hostname fqdn> -ttl <ttl in seconds> ", UserSessionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"uid", (Object)new TextInputParameter("uid", "user-id", true, null)).put((Object)"sessionid", (Object)new TextInputParameter("sessionid", "session-id", true, null)).put((Object)"apiserver", (Object)new TextInputParameter("apiserver", "apiserver fqdn hostname", true, null)).put((Object)"ttl", (Object)new IntegerInputParameter("ttl", "Time to Live in milli seconds", true, null)).build(), null).setShortUsage("usersession update -uid <user-id> -sessionid <session-id> -apiserver <hostname fqdn> -ttl <ttl in seconds> ");
    public static final CLICommand UserSessionRemoveCommand = new CLICommand("remove", "usersession remove -sessionid <session-id> -uid <user-id> -apiserver <hostname fqdn> ", UserSessionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"uid", (Object)new TextInputParameter("uid", "user-id", true, null)).put((Object)"sessionid", (Object)new TextInputParameter("sessionid", "session-id", true, null)).put((Object)"apiserver", (Object)new TextInputParameter("apiserver", "apiserver fqdn hostname", true, null)).build(), null).setShortUsage("usersession remove -sessionid <session-id> -uid <user-id> -apiserver <hostname fqdn> ");
    public static final CLICommand UserSessionRemoveAllCommand = new CLICommand("removeall", "usersession removeall -apiserver <hostname fqdn>", UserSessionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"apiserver", (Object)new TextInputParameter("apiserver", "apiserver fqdn hostname", true, null)).build(), null).setShortUsage("usersession removeall -apiserver <hostname fqdn>");
    public static final CLICommand UserSessionListCommand = new CLICommand("list", "usersession list [-filter <filters>]", UserSessionCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"output", (Object)new TextInputParameter("output", "verbose", false, "verbose")).build(), null).setUsageInVisible(true).setShortUsage("usersession list [-filter <filters>]");
    private static final CLICommand[] usersessionCommands = new CLICommand[]{UserSessionGetCommand, UserSessionAddCommand, UserSessionUpdateCommand, UserSessionRemoveCommand, UserSessionRemoveAllCommand, UserSessionListCommand};
    public static final CLICommand userSessionCommands = new CLICommand("usersession", "usersession [get|add|update|remove|removeall]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, usersessionCommands).setShortUsage("usersession [get|add|update|remove|removeall]");
    public static Map<CLDBProto.ApisUserSessionInfoFields, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)CLDBProto.ApisUserSessionInfoFields.userid, (Object)new FieldInfo(CLDBProto.ApisUserSessionInfoFields.userid.getNumber(), "uid", "userid", String.class)).put((Object)CLDBProto.ApisUserSessionInfoFields.sessionid, (Object)new FieldInfo(CLDBProto.ApisUserSessionInfoFields.sessionid.getNumber(), "sid", "sessionid", String.class)).put((Object)CLDBProto.ApisUserSessionInfoFields.apiserverhost, (Object)new FieldInfo(CLDBProto.ApisUserSessionInfoFields.apiserverhost.getNumber(), "api", "apiserverhost", String.class)).put((Object)CLDBProto.ApisUserSessionInfoFields.ttl, (Object)new FieldInfo(CLDBProto.ApisUserSessionInfoFields.ttl.getNumber(), "ttl", "ttl", Long.class)).build();
    private static int MAX_APISUSERSESSIONINFOFIELD = 0;

    public UserSessionCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String commandName = this.cliCommand.getCommandName().toLowerCase(Locale.ENGLISH);
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase(COMMAND_APIS_USERSESSION_GET)) {
                return this.getUserSession();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(COMMAND_APIS_USERSESSION_ADD)) {
                return this.addUserSession();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(COMMAND_APIS_USERSESSION_UPDATE)) {
                return this.updateUserSession();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(COMMAND_APIS_USERSESSION_REMOVE)) {
                return this.removeUserSession();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(COMMAND_APIS_USERSESSION_REMOVEALL)) {
                return this.removeAllUserSession();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(COMMAND_APIS_USERSESSION_LIST)) {
                return this.listUserSessions();
            }
            return new TextCommandOutput("usersession command failed".getBytes());
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)("MaprSecurityException in command:" + commandName), (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException:", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("usersession command " + commandName + "failed, exception:"), (Throwable)e);
            throw new CLIProcessingException("usersession command " + commandName + "failed, exception:", (Throwable)e);
        }
    }

    CommandOutput getUserSession() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String uid = this.getParamTextValue(PARAM_UID, 0);
        CLDBProto.ApisUserSessionGetRequest req = CLDBProto.ApisUserSessionGetRequest.newBuilder().setCreds(this.getUserCredentials()).setUserId(uid).build();
        LOG.debug((Object)("getUserSession: req:" + req.toString()));
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ApisUserSessionGetProc.getNumber(), (MessageLite)req, CLDBProto.ApisUserSessionGetResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ApisUserSessionGetResponse resp = CLDBProto.ApisUserSessionGetResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String info = this.getUSerSessionDetails(resp.getNumActiveSessions(), resp.getMaxConcurrentUserSessions());
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg() + info));
                return output;
            }
            CommandOutput.OutputHierarchy.OutputNode opnode = new CommandOutput.OutputHierarchy.OutputNode();
            opnode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numActiveSessions", resp.getNumActiveSessions()));
            opnode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxConcurrentSessions", resp.getMaxConcurrentUserSessions()));
            oh.addNode(opnode);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput addUserSession() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        CLDBProto.ApisUserSessionAddRequest req = CLDBProto.ApisUserSessionAddRequest.newBuilder().setCreds(this.getUserCredentials()).setSessionInfo(this.buildApisUserSessionInfo()).build();
        LOG.debug((Object)("getUserSession: req:" + req.toString()));
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ApisUserSessionAddProc.getNumber(), (MessageLite)req, CLDBProto.ApisUserSessionAddResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ApisUserSessionAddResponse resp = CLDBProto.ApisUserSessionAddResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String info = this.getUSerSessionDetails(resp.getNumActiveSessions(), resp.getMaxConcurrentUserSessions());
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg() + info));
                return output;
            }
            CommandOutput.OutputHierarchy.OutputNode opnode = new CommandOutput.OutputHierarchy.OutputNode();
            opnode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numActiveSessions", resp.getNumActiveSessions()));
            opnode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxConcurrentSessions", resp.getMaxConcurrentUserSessions()));
            oh.addNode(opnode);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput updateUserSession() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        CLDBProto.ApisUserSessionUpdateRequest req = CLDBProto.ApisUserSessionUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setSessionInfo(this.buildApisUserSessionInfo()).build();
        LOG.debug((Object)("getUserSession: req:" + req.toString()));
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ApisUserSessionUpdateProc.getNumber(), (MessageLite)req, CLDBProto.ApisUserSessionUpdateResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ApisUserSessionUpdateResponse resp = CLDBProto.ApisUserSessionUpdateResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String info = this.getUSerSessionDetails(resp.getNumActiveSessions(), resp.getMaxConcurrentUserSessions());
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg() + info));
                return output;
            }
            CommandOutput.OutputHierarchy.OutputNode opnode = new CommandOutput.OutputHierarchy.OutputNode();
            opnode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numActiveSessions", resp.getNumActiveSessions()));
            opnode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxConcurrentSessions", resp.getMaxConcurrentUserSessions()));
            oh.addNode(opnode);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput removeUserSession() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        CLDBProto.ApisUserSessionRemoveRequest req = CLDBProto.ApisUserSessionRemoveRequest.newBuilder().setCreds(this.getUserCredentials()).setSessionInfo(this.buildApisUserSessionInfo(false)).build();
        LOG.debug((Object)("getUserSession: req:" + req.toString()));
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ApisUserSessionRemoveProc.getNumber(), (MessageLite)req, CLDBProto.ApisUserSessionRemoveResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ApisUserSessionRemoveResponse resp = CLDBProto.ApisUserSessionRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String info = this.getUSerSessionDetails(resp.getNumActiveSessions(), resp.getMaxConcurrentUserSessions());
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg() + info));
                return output;
            }
            CommandOutput.OutputHierarchy.OutputNode opnode = new CommandOutput.OutputHierarchy.OutputNode();
            opnode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numActiveSessions", resp.getNumActiveSessions()));
            opnode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxConcurrentSessions", resp.getMaxConcurrentUserSessions()));
            oh.addNode(opnode);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    private String getUSerSessionDetails(Integer num, Integer max) {
        StringBuilder msg = new StringBuilder();
        if (num != null) {
            msg.append(", numActiveSessions:" + num);
        }
        if (max != null) {
            msg.append(", maxConcurrentSessions:" + max);
        }
        return msg.toString();
    }

    CommandOutput removeAllUserSession() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String host = this.getParamTextValue(PARAM_APISERVER, 0);
        CLDBProto.ApisUserSessionRemoveAllRequest req = CLDBProto.ApisUserSessionRemoveAllRequest.newBuilder().setCreds(this.getUserCredentials()).setApiServerHost(host).build();
        LOG.debug((Object)("getUserSession: req:" + req.toString()));
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ApisUserSessionRemoveAllProc.getNumber(), (MessageLite)req, CLDBProto.ApisUserSessionRemoveAllResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ApisUserSessionRemoveAllResponse resp = CLDBProto.ApisUserSessionRemoveAllResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String info = this.getUSerSessionDetails(null, resp.getMaxConcurrentUserSessions());
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg() + info));
                return output;
            }
            CommandOutput.OutputHierarchy.OutputNode opnode = new CommandOutput.OutputHierarchy.OutputNode();
            opnode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxConcurrentSessions", resp.getMaxConcurrentUserSessions()));
            oh.addNode(opnode);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput listUserSessions() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        this.list(oh);
        return output;
    }

    private CLDBProto.ApisUserSessionInfo buildApisUserSessionInfo() throws CLIProcessingException {
        return this.buildApisUserSessionInfo(true);
    }

    private CLDBProto.ApisUserSessionInfo buildApisUserSessionInfo(boolean includeTtl) throws CLIProcessingException {
        String uid = this.getParamTextValue(PARAM_UID, 0);
        String sid = this.getParamTextValue(PARAM_SESSIONID, 0);
        String host = this.getParamTextValue(PARAM_APISERVER, 0);
        if (includeTtl) {
            int ttl = this.getParamIntValue(PARAM_TTL, 0);
            return CLDBProto.ApisUserSessionInfo.newBuilder().setUserId(uid).setSessionId(sid).setApiServerHost(host).setTtl((long)ttl).build();
        }
        return CLDBProto.ApisUserSessionInfo.newBuilder().setUserId(uid).setSessionId(sid).setApiServerHost(host).build();
    }

    private BitSet getColumns() throws CLIProcessingException {
        String columnsString;
        BitSet columns = new BitSet();
        columns.set(0, MAX_APISUSERSESSIONINFOFIELD + 1);
        String string = columnsString = this.isParamPresent(PARAM_COLUMNS) ? this.getParamTextValue(PARAM_COLUMNS, 0) : null;
        if (columnsString != null && !columnsString.equals("all")) {
            columns = FilterUtil.getColumns(fieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatApisUserSessionInfo(CLDBProto.ApisUserSessionInfo session) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        boolean terse = false;
        if (this.isParamPresent(PARAM_OUTPUT)) {
            String op = this.getParamTextValue(PARAM_OUTPUT, 0);
            terse = op.equals("terse");
        }
        BitSet columns = this.getColumns();
        if (session.hasUserId() && columns.get(CLDBProto.ApisUserSessionInfoFields.userid.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ApisUserSessionInfoFields.userid).getName(terse), (Object)session.getUserId()));
        }
        if (session.hasSessionId() && columns.get(CLDBProto.ApisUserSessionInfoFields.sessionid.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ApisUserSessionInfoFields.sessionid).getName(terse), (Object)session.getSessionId()));
        }
        if (session.hasApiServerHost() && columns.get(CLDBProto.ApisUserSessionInfoFields.apiserverhost.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ApisUserSessionInfoFields.apiserverhost).getName(terse), (Object)session.getApiServerHost()));
        }
        if (session.hasTtl() && columns.get(CLDBProto.ApisUserSessionInfoFields.ttl.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ApisUserSessionInfoFields.ttl).getName(terse), (Object)this.longToDate(session.getTtl())));
        }
        return outputNode;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.ApisUserSessionListResponse resp = (CLDBProto.ApisUserSessionListResponse)response;
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            return;
        }
        for (CLDBProto.ApisUserSessionInfo session : resp.getSessionsList()) {
            CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatApisUserSessionInfo(session);
            out.addNode(outputNode);
        }
        if (resp.hasTotal()) {
            out.setTotal(-1);
        }
    }

    @Override
    public MessageLite sendRequest(MessageLite request) throws CLIProcessingException {
        byte[] replyData;
        CLDBProto.ApisUserSessionListRequest req = (CLDBProto.ApisUserSessionListRequest)request;
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ApisUserSessionListProc.getNumber(), (MessageLite)req, CLDBProto.ApisUserSessionListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return CLDBProto.ApisUserSessionListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("InvalidProtocolBufferException parsing ApisUserSessionListResponse", (Throwable)ipbe);
            }
        }
        LOG.error((Object)"RPC Request to list user-sessions failed. No data returned");
        return null;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.ApisUserSessionListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.ApisUserSessionListRequest.newBuilder((CLDBProto.ApisUserSessionListRequest)((CLDBProto.ApisUserSessionListRequest)prevReq)) : this.getApisUserSessionListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            CLDBProto.ApisUserSessionListResponse resp = (CLDBProto.ApisUserSessionListResponse)prevResp;
            int prevCount = resp.getSessionsCount();
            int origStart = this.isParamPresent(PARAM_START) ? this.getParamIntValue(PARAM_START, 0) : 0;
            int origLimit = this.isParamPresent(PARAM_LIMIT) ? this.getParamIntValue(PARAM_LIMIT, 0) : Integer.MAX_VALUE;
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    private CLDBProto.ApisUserSessionListRequest.Builder getApisUserSessionListRequestBuilder() throws CLIProcessingException {
        CLDBProto.ApisUserSessionListRequest.Builder reqBuilder = CLDBProto.ApisUserSessionListRequest.newBuilder().setCreds(this.getUserCredentials());
        if (this.isParamPresent(PARAM_START) && this.isParamPresent(PARAM_LIMIT)) {
            reqBuilder.setLimiter(this.getNextLimiter(this.getParamIntValue(PARAM_START, 0), 0, this.getParamIntValue(PARAM_START, 0), this.getParamIntValue(PARAM_LIMIT, 0), 100));
        }
        if (this.isParamPresent(PARAM_FILTER)) {
            List<CLIProto.Filter> filters = this.getFilters(fieldTable, PARAM_FILTER);
            reqBuilder.addAllFilter(filters);
        }
        return reqBuilder;
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        int start = this.isParamPresent(PARAM_START) ? this.getParamIntValue(PARAM_START, 0) : 0;
        int limit = this.isParamPresent(PARAM_LIMIT) ? this.getParamIntValue(PARAM_LIMIT, 0) : Integer.MAX_VALUE;
        CLDBProto.ApisUserSessionListResponse resp = (CLDBProto.ApisUserSessionListResponse)prevResp;
        int numItemsReceived = resp.getSessionsCount();
        boolean retVal = this.hasMore(start, limit, ((CLDBProto.ApisUserSessionListRequest)prevReq).getLimiter().getStart(), numItemsReceived);
        LOG.debug((Object)("hasMore: " + start + ", " + limit + ", " + ((CLDBProto.ApisUserSessionListRequest)prevReq).getLimiter().getStart() + ", " + numItemsReceived + ",   hasMore:" + retVal));
        return retVal;
    }

    private String longToDate(long millis) {
        Date date = new Date(millis);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        return formatter.format(date);
    }

    static {
        CLDBProto.ApisUserSessionInfoFields[] values = CLDBProto.ApisUserSessionInfoFields.values();
        int max = 0;
        for (CLDBProto.ApisUserSessionInfoFields value : values) {
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_APISUSERSESSIONINFOFIELD = max;
    }
}

