/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.NodeServicesManagementCommand;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ZeppManager;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.apache.zeppelin.client.ParagraphResult;

public class InsightCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(NodeServicesManagementCommand.class);
    public static final int MAX_CHARS_COUNT = 60;
    public static final String INSIGHT_PARAM = "insight";
    public static final String SETCONFIG_PARAM = "cluster";
    public static final String STATUS_PARAM = "info";
    public static final String PURGE_PARAM = "purge";
    public static final String ENABLE_PARAM = "enable";
    public static final String TRIALMODE_PARAM = "trialmode";
    public static final String NODES_PARAM = "nodes";
    public static final String TYPE_PARAM = "type";
    public static final String SUMMARY_TABLE_PARAM = "summary-table";
    public static final String VERBOSE_PARAM = "verbose";
    public static final String RETENTION_DAYS_PARAM = "retentionDays";
    public static final String INSIGHT_USAGE = "insight [cluster | info | purge | dashboard]";
    public static final String SETCONFIG_USAGE = "cluster -enable <true|false>[-node <name> | -type [mfs|s3|auth|cldb] ] ";
    public static final String STATUS_USAGE = "info [-node <name> | -type [mfs|s3|auth|cldb] ] -purge <true|false> [-summary-table [-id] [-verbose <true/false>]] [-dashboard [-id]]";
    public static final String PURGE_USAGE = "purge [-retentionDays <nDays>]";
    public static final String MODE_USAGE = "-trialmode <true|false>";
    public static final String ID_PARAM = "id";
    public static final String DASHBOARD_QUERY_USAGE = "dashboard [-enable <true/false> [ -id <n> ]] | [-configure -jsessionid <id> [-zeppelin <ip/hostname>]] | [-run -queryid <n> -jsessionid <id> [-logparastatus] [-zeppelin <ip>] [-notebook <Nbpath>]] ";
    public static final String DASHBOARD_PARAM = "dashboard";
    public static final String CONFIGURE_PARAM = "configure";
    public static final String ZEPPELIN_PARAM = "zeppelin";
    public static final String JSESSIONID_PARAM = "jsessionid";
    public static final String RUN_PARAM = "run";
    public static final String QUERYID_PARAM = "queryid";
    public static final String NOTEBOOK_PARAM = "notebook";
    public static final String PARASTATUS_PARAM = "logparastatus";
    private String DEFAULT_ZEPP_NBPATH = "/Insights";
    private ZeppManager zeppManager = null;
    public static final CLICommand setConfigCommand = new CLICommand("cluster", "insight cluster config command ", InsightCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"enable", (Object)new BooleanInputParameter("enable", "set true/false", false, null)).put((Object)"trialmode", (Object)new BooleanInputParameter("trialmode", "set true/false", false, null).setInvisible(true)).put((Object)"nodes", (Object)new TextInputParameter("nodes", "node names space separated ", false, null)).put((Object)"type", (Object)new TextInputParameter("type", "audit type [mfs, s3, auth, cldb] ", false, null)).build(), null).setShortUsage("cluster -enable <true|false>[-node <name> | -type [mfs|s3|auth|cldb] ] ");
    public static final CLICommand statusCommand = new CLICommand("info", "insight info command ", InsightCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"nodes", (Object)new TextInputParameter("nodes", "node names space separated ", false, null)).put((Object)"type", (Object)new TextInputParameter("type", "audit type [mfs, s3, auth, cldb] ", false, null)).put((Object)"purge", (Object)new BooleanInputParameter("purge", "true/false", false, null)).put((Object)"dashboard", (Object)new NoValueInputParameter("dashboard", "to list dashboard query; supports -id option;", false, false)).put((Object)"summary-table", (Object)new NoValueInputParameter("summary-table", "list or display status of summary tables; supports -id and -verbose options;", false, false)).put((Object)"id", (Object)new IntegerInputParameter("id", "<n>. Use with -summary-table or -dashboard only", false, null)).put((Object)"verbose", (Object)new BooleanInputParameter("verbose", "true/false. Use with -summary-table only", false, null)).build(), null).setShortUsage("info [-node <name> | -type [mfs|s3|auth|cldb] ] -purge <true|false> [-summary-table [-id] [-verbose <true/false>]] [-dashboard [-id]]");
    public static final CLICommand purgeCommand = new CLICommand("purge", "insight purge command ", InsightCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"retentionDays", (Object)new IntegerInputParameter("retentionDays", "set retention days", true, null)).build(), null).setShortUsage("purge [-retentionDays <nDays>]");
    public static final CLICommand dashboardCommand = new CLICommand("dashboard", "insight dashboard query info command ", InsightCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"enable", (Object)new BooleanInputParameter("enable", "true/false dashboard query(ies)", false, null)).put((Object)"id", (Object)new IntegerInputParameter("id", "dashboard query identifier <n>", false, null)).put((Object)"configure", (Object)new NoValueInputParameter("configure", "to configure zeppelin notebook on the given ip/hostname; supports -zeppelin, -jsessionid options;", false, false)).put((Object)"run", (Object)new NoValueInputParameter("run", "run zeppelin notebook; supports -zeppelin, -jsessionid, -notebook, -queryid, logparastatus options;", false, false)).put((Object)"zeppelin", (Object)new TextInputParameter("zeppelin", "<ip/hostname> to configure, can be used with -run or -configure only", false, null)).put((Object)"jsessionid", (Object)new TextInputParameter("jsessionid", "dashboard jsession id <n> needs to be used with -run or -configure only", false, null)).put((Object)"logparastatus", (Object)new NoValueInputParameter("logparastatus", "logs the paragraph result. Use with -run only", false, false)).put((Object)"notebook", (Object)new TextInputParameter("notebook", "notebook path. Use with -run only", false, null)).put((Object)"queryid", (Object)new IntegerInputParameter("queryid", "dashboard query id. Use with -run only", false, null)).build(), null).setShortUsage("dashboard [-enable <true/false> [ -id <n> ]] | [-configure -jsessionid <id> [-zeppelin <ip/hostname>]] | [-run -queryid <n> -jsessionid <id> [-logparastatus] [-zeppelin <ip>] [-notebook <Nbpath>]] ");
    public static final CLICommand insightCommands = new CLICommand("insight", "insight [cluster | info | purge | dashboard]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{setConfigCommand, statusCommand, purgeCommand, dashboardCommand}).setShortUsage("insight [cluster | info | purge | dashboard]");

    public InsightCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        if (!super.validateInput()) {
            output.setOutput(out);
            return output;
        }
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase(SETCONFIG_PARAM)) {
            try {
                return this.processSetConfig();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (command.equalsIgnoreCase(STATUS_PARAM)) {
            try {
                return this.processGetStatus();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (command.equalsIgnoreCase(PURGE_PARAM)) {
            try {
                return this.processPurge();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (command.equalsIgnoreCase(DASHBOARD_PARAM)) {
            try {
                return this.processDashboardQuery();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput(("Insight command failed: unknown command " + command + " received.").getBytes());
    }

    CommandOutput processSetConfig() throws CLIProcessingException {
        CLDBProto.InsightConfigUpdateRequest.Builder req;
        CommandOutput.OutputHierarchy out;
        CommandOutput output;
        block16: {
            output = new CommandOutput();
            out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            req = CLDBProto.InsightConfigUpdateRequest.newBuilder();
            if (!this.isParamPresent(ENABLE_PARAM) && !this.isParamPresent(TRIALMODE_PARAM)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing enable option. Check usage"));
                return output;
            }
            if (this.isParamPresent(ENABLE_PARAM) && this.isParamPresent(TRIALMODE_PARAM)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Both enable and trialmode cannot be present at same time"));
                return output;
            }
            boolean trialModeCfg = false;
            boolean trialMode = false;
            boolean enable = false;
            if (this.isParamPresent(TRIALMODE_PARAM)) {
                trialModeCfg = true;
                trialMode = this.getParamBooleanValue(TRIALMODE_PARAM, 0);
            } else {
                enable = this.getParamBooleanValue(ENABLE_PARAM, 0);
                if (!this.isValidParamCombination(out)) {
                    return output;
                }
            }
            try {
                if (trialModeCfg) {
                    CLDBProto.InsightConfig.Builder config = CLDBProto.InsightConfig.newBuilder();
                    req.setCreds(this.getUserCredentials());
                    config.setTrialModeEnabled(trialMode);
                    req.setInsightGlobalConfig(config.build());
                    break block16;
                }
                if (this.isGlobalConfig()) {
                    List<String> inputTypesList = this.prepareParamValueList(TYPE_PARAM);
                    inputTypesList = this.verifyTypes(inputTypesList, out);
                    CLDBProto.InsightConfig.Builder config = CLDBProto.InsightConfig.newBuilder();
                    req.setCreds(this.getUserCredentials());
                    config.setEnabled(enable);
                    this.populateTypeConfig(inputTypesList, config, enable);
                    req.setInsightGlobalConfig(config.build());
                    break block16;
                }
                List<String> inputNodeList = this.prepareParamValueList(NODES_PARAM);
                List<String> inputTypeList = new ArrayList<String>();
                try {
                    inputNodeList = this.verifyNodes(inputNodeList, out);
                    inputTypeList = this.verifyTypes(inputTypeList, out);
                }
                catch (Exception e) {
                    return output;
                }
                req.setCreds(this.getUserCredentials());
                this.populateConfig(req, inputNodeList, inputTypeList, enable, out);
            }
            catch (CLIProcessingException e) {
                LOG.error((Object)("Exception during set config " + e));
                throw new CLIProcessingException("Unable to parse request.", (Throwable)e);
            }
        }
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightConfigUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightConfigUpdateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.InsightConfigUpdateResponse resp = CLDBProto.InsightConfigUpdateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                out.addMessage("Updated insight Config Successfully. ");
                return output;
            }
            String errorMsg = "Unable to update insight Config " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
            return output;
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Exception during set config " + e));
            throw new CLIProcessingException("CLIProcessingException " + e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during set config " + e.getMessage()));
            return output;
        }
    }

    void processDashboardQueryOutput(CLDBProto.InsightDashboardQueryResponse resp, CommandOutput.OutputHierarchy out) {
        CommandOutput.OutputHierarchy.OutputNode master = new CommandOutput.OutputHierarchy.OutputNode();
        master.addChild(new CommandOutput.OutputHierarchy.OutputNode("insightMaster", (Object)resp.getInsightMaster()));
        master.addChild(new CommandOutput.OutputHierarchy.OutputNode("hmsMaster", (Object)resp.getHmsMaster()));
        master.addChild(new CommandOutput.OutputHierarchy.OutputNode("sparkMaster", (Object)resp.getSparkMaster()));
        master.addChild(new CommandOutput.OutputHierarchy.OutputNode("zeppelinMaster", (Object)resp.getZeppelinMaster()));
        master.addChild(new CommandOutput.OutputHierarchy.OutputNode("zeppelinPort", resp.getZeppelinPort()));
        out.addNode(master);
        for (CLDBProto.InsightDashboardQuery insightDashboardQuery : resp.getQueriesList()) {
            CommandOutput.OutputHierarchy.OutputNode dashboardStatus = new CommandOutput.OutputHierarchy.OutputNode();
            if (insightDashboardQuery.hasQueryId()) {
                dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("queryId", insightDashboardQuery.getQueryId()));
            }
            if (insightDashboardQuery.hasQueryName()) {
                dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("queryName", (Object)insightDashboardQuery.getQueryName()));
            }
            if (insightDashboardQuery.hasQueryDesc()) {
                dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("queryDesc", (Object)insightDashboardQuery.getQueryDesc()));
            }
            if (insightDashboardQuery.hasSummaryTableId()) {
                dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("summaryTableId", insightDashboardQuery.getSummaryTableId()));
            }
            if (insightDashboardQuery.hasSummaryTableName()) {
                dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("summaryTableName", (Object)insightDashboardQuery.getSummaryTableName()));
            }
            if (insightDashboardQuery.hasSqlSummaryQuery()) {
                dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("sqlSummaryQuery", (Object)insightDashboardQuery.getSqlSummaryQuery()));
            }
            if (insightDashboardQuery.hasSqlBaseQuery()) {
                dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("sqlBaseQuery", (Object)insightDashboardQuery.getSqlBaseQuery()));
            }
            if (insightDashboardQuery.hasEnabled()) {
                dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("enabled", (Object)insightDashboardQuery.getEnabled()));
            }
            for (CLDBProto.InsightSummaryTableStatus summTableStatus : resp.getSummaryTableStatusesList()) {
                if (summTableStatus.getTableId() != insightDashboardQuery.getSummaryTableId()) continue;
                if (summTableStatus.hasStatusCode()) {
                    dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("statusCode", summTableStatus.getStatusCode()));
                }
                if (summTableStatus.hasQueryCompleteTime()) {
                    dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("queryCompleteTime", (Object)InsightCommands.epochMillisToStr(summTableStatus.getQueryCompleteTime())));
                }
                if (!summTableStatus.hasRunning()) continue;
                dashboardStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("isRunning", (Object)summTableStatus.getRunning()));
            }
            out.addNode(dashboardStatus);
        }
    }

    void processSummaryTableOutput(CLDBProto.InsightDashboardQueryResponse resp, CommandOutput.OutputHierarchy out) {
        CommandOutput.OutputHierarchy.OutputNode master = new CommandOutput.OutputHierarchy.OutputNode();
        master.addChild(new CommandOutput.OutputHierarchy.OutputNode("insightMaster", (Object)resp.getInsightMaster()));
        master.addChild(new CommandOutput.OutputHierarchy.OutputNode("hmsMaster", (Object)resp.getHmsMaster()));
        master.addChild(new CommandOutput.OutputHierarchy.OutputNode("sparkMaster", (Object)resp.getSparkMaster()));
        out.addNode(master);
        for (CLDBProto.InsightSummaryTable summTable : resp.getTablesList()) {
            CommandOutput.OutputHierarchy.OutputNode status = new CommandOutput.OutputHierarchy.OutputNode();
            if (summTable.hasTableId()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("tableId", summTable.getTableId()));
            }
            if (summTable.hasTableName()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("tableName", (Object)summTable.getTableName()));
            }
            if (summTable.hasTableDesc()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("tableDesc", (Object)summTable.getTableDesc()));
            }
            if (summTable.hasEnabled()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("enabled", (Object)summTable.getEnabled()));
            }
            if (summTable.hasSqlQueryForUpdate()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("queryForUpdate", (Object)summTable.getSqlQueryForUpdate()));
            }
            if (this.isParamPresent(VERBOSE_PARAM)) {
                this.processSummTableVerboseOutput(summTable.getTableId(), status, resp);
            }
            out.addNode(status);
        }
    }

    void processSummTableVerboseOutput(int id, CommandOutput.OutputHierarchy.OutputNode status, CLDBProto.InsightDashboardQueryResponse resp) {
        for (CLDBProto.InsightSummaryTableStatus summTableStatus : resp.getSummaryTableStatusesList()) {
            if (summTableStatus.getTableId() != id) continue;
            if (summTableStatus.hasStatusCode()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("statusCode", summTableStatus.getStatusCode()));
            }
            if (summTableStatus.hasSrcMinTs()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("sourceDataStartTime", (Object)InsightCommands.epochMillisToStr(summTableStatus.getSrcMinTs())));
            }
            if (summTableStatus.hasSrcMaxTs()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("sourceDataEndTime", (Object)InsightCommands.epochMillisToStr(summTableStatus.getSrcMaxTs())));
            }
            if (summTableStatus.hasStatusMessage()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("statusMessage", (Object)summTableStatus.getStatusMessage()));
            }
            if (summTableStatus.hasQueryStartTime()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("queryRunStartTime", (Object)InsightCommands.epochMillisToStr(summTableStatus.getQueryStartTime())));
            }
            if (summTableStatus.hasQueryCompleteTime()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("queryRunEndTime", (Object)InsightCommands.epochMillisToStr(summTableStatus.getQueryCompleteTime())));
            }
            if (summTableStatus.hasStatusTime()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("statusTime", (Object)InsightCommands.epochMillisToStr(summTableStatus.getStatusTime())));
            }
            if (summTableStatus.hasNRecordsAdded()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("noOfRecordsAdded", summTableStatus.getNRecordsAdded()));
            }
            if (summTableStatus.hasRunning()) {
                status.addChild(new CommandOutput.OutputHierarchy.OutputNode("isRunning", (Object)summTableStatus.getRunning()));
            }
            if (!summTableStatus.hasQueryJobId()) continue;
            status.addChild(new CommandOutput.OutputHierarchy.OutputNode("queryJobId", summTableStatus.getQueryJobId()));
        }
    }

    CommandOutput processGetDashboardStatus(CommandOutput output) throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        int queryId = 0;
        CLDBProto.InsightDashboardQueryRequest.Builder req = CLDBProto.InsightDashboardQueryRequest.newBuilder();
        if (this.isParamPresent(ID_PARAM)) {
            queryId = this.getParamIntValue(ID_PARAM, 0);
            req.setId(queryId);
        }
        req.setOpType(CLDBProto.InsightDashboardOpType.QUERY_LIST);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightDashboardQueryProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightDashboardQueryResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.InsightDashboardQueryResponse resp = CLDBProto.InsightDashboardQueryResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                if (resp.getQueriesCount() <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No queries available for reporting status."));
                    output.setOutput(out);
                    return output;
                }
            } else {
                String errorMsg = "Unable to fetch dashboard query info";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
                return output;
            }
            this.processDashboardQueryOutput(resp, out);
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Exception during processing dashboard query. " + e));
            throw new CLIProcessingException("CLIProcessingException " + e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception processing dashboard query. " + e.getMessage()));
        }
        return output;
    }

    CommandOutput processSummaryTable(CommandOutput output) throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.InsightDashboardQueryRequest.Builder req = CLDBProto.InsightDashboardQueryRequest.newBuilder();
        if (this.isParamPresent(ID_PARAM)) {
            int idParam = this.getParamIntValue(ID_PARAM, 0);
            req.setId(idParam);
        }
        req.setCreds(this.getUserCredentials());
        req.setOpType(CLDBProto.InsightDashboardOpType.SUMMARY_TABLE_STATUS);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightDashboardQueryProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightDashboardQueryResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.InsightDashboardQueryResponse resp = CLDBProto.InsightDashboardQueryResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                if (resp.getTablesCount() <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No summary tables available to report."));
                    output.setOutput(out);
                    return output;
                }
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                return output;
            }
            this.processSummaryTableOutput(resp, out);
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Exception during processing dashboard query. " + e));
            throw new CLIProcessingException("CLIProcessingException " + e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception processing dashboard query. " + e.getMessage()));
        }
        return output;
    }

    CommandOutput processGetStatus() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isValidParamCombination(out)) {
            return output;
        }
        if (this.isParamPresent(DASHBOARD_PARAM)) {
            this.processGetDashboardStatus(output);
            return output;
        }
        if (this.isParamPresent(SUMMARY_TABLE_PARAM)) {
            this.processSummaryTable(output);
            return output;
        }
        CLDBProto.InsightStatusRequest.Builder req = CLDBProto.InsightStatusRequest.newBuilder();
        List<String> inputNodeList = this.prepareParamValueList(NODES_PARAM);
        List<String> inputTypeList = this.prepareParamValueList(TYPE_PARAM);
        boolean needPurge = false;
        boolean purgeOptionEn = false;
        boolean typeOptionEn = false;
        boolean nodeOptionEn = false;
        if (this.isParamPresent(PURGE_PARAM)) {
            needPurge = this.getParamBooleanValue(ENABLE_PARAM, 0);
            for (CLDBProto.InsightTypeConfig.InsightType type : CLDBProto.InsightTypeConfig.InsightType.values()) {
                inputTypeList.add(type.name());
            }
            purgeOptionEn = true;
        }
        try {
            if (this.isParamPresent(NODES_PARAM)) {
                inputNodeList = this.verifyNodes(inputNodeList, out);
                nodeOptionEn = true;
            } else if (this.isParamPresent(TYPE_PARAM)) {
                inputTypeList = this.verifyTypes(inputTypeList, out);
                typeOptionEn = true;
            } else if (!this.isParamPresent(PURGE_PARAM)) {
                needPurge = true;
                for (CLDBProto.InsightTypeConfig.InsightType type : CLDBProto.InsightTypeConfig.InsightType.values()) {
                    inputTypeList.add(type.name());
                }
            }
        }
        catch (Exception e) {
            return output;
        }
        req.setCreds(this.getUserCredentials());
        req.addAllNodes(inputNodeList);
        req.addAllTypes(this.prepareTypes(inputTypeList));
        req.setNeedPurge(needPurge);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightStatusResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.InsightStatusResponse resp = CLDBProto.InsightStatusResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String errorMsg = "Unable to get insight status " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
                return output;
            }
            this.processStatusOutput(nodeOptionEn, typeOptionEn, purgeOptionEn, resp, out);
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Exception during get insight status " + e));
            throw new CLIProcessingException("CLIProcessingException " + e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during get insight status " + e.getMessage()));
        }
        return output;
    }

    boolean isGlobalConfig() {
        return !this.isParamPresent(NODES_PARAM);
    }

    boolean isValidParamCombination(CommandOutput.OutputHierarchy out) {
        boolean isNodesParamPresent = this.isParamPresent(NODES_PARAM);
        boolean isTypeParamPresent = this.isParamPresent(TYPE_PARAM);
        boolean isDashboardParamPresent = this.isParamPresent(DASHBOARD_PARAM);
        boolean isPurgeParamPresent = this.isParamPresent(PURGE_PARAM);
        boolean isEnableParamPresent = this.isParamPresent(ENABLE_PARAM);
        boolean isConfigureParamPresent = this.isParamPresent(CONFIGURE_PARAM);
        boolean isZeppelinParamPresent = this.isParamPresent(ZEPPELIN_PARAM);
        boolean isJessionIdParamPresent = this.isParamPresent(JSESSIONID_PARAM);
        boolean isIdParamPresent = this.isParamPresent(ID_PARAM);
        boolean isRunParamPresent = this.isParamPresent(RUN_PARAM);
        boolean isSummaryTableParamPresent = this.isParamPresent(SUMMARY_TABLE_PARAM);
        boolean isVerboseParamPresent = this.isParamPresent(VERBOSE_PARAM);
        if (isNodesParamPresent && isTypeParamPresent) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Both -nodes and -types cannot be provided simultaneously. Check usage"));
            return false;
        }
        if (isDashboardParamPresent && (isNodesParamPresent || isTypeParamPresent || isPurgeParamPresent)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Dashboard Parameter cannot be used with nodes param, type param or purge param."));
            return false;
        }
        if (isEnableParamPresent && (isConfigureParamPresent || isZeppelinParamPresent || isJessionIdParamPresent)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Configure Parameter, JsessionId Parameter or Zeppelin Parameter cannot be used with Enable Parameter."));
            return false;
        }
        if (isIdParamPresent && (isConfigureParamPresent || isZeppelinParamPresent || isJessionIdParamPresent)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Configure Parameter, JsessionId Parameter or Zeppelin Parameter cannot be used with ID Parameter."));
            return false;
        }
        if (isRunParamPresent && (isEnableParamPresent || isIdParamPresent)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "run Parameter cannot be used with enable, id param."));
            return false;
        }
        if (isSummaryTableParamPresent && isDashboardParamPresent) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid parameters: summary-table and dashboard cannot be used together."));
            return false;
        }
        if (!isSummaryTableParamPresent && !isDashboardParamPresent && isIdParamPresent) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "id is only valid with -summary-table or -dashboard parameter."));
            return false;
        }
        if (!isSummaryTableParamPresent && isVerboseParamPresent) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "verbose is only valid with -summary-table parameter."));
            return false;
        }
        if (isSummaryTableParamPresent && (isNodesParamPresent || isTypeParamPresent || isPurgeParamPresent)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "-summary-table cannot be used with -nodes, -purge or -type."));
            return false;
        }
        return true;
    }

    List<String> verifyNodes(List<String> inputNodeList, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (inputNodeList == null || inputNodeList.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Nodes not found"));
            throw new CLIProcessingException("Nodes not found.");
        }
        String zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
        if (zkConnectString == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Unable to obtain the ZooKeeper connection string"));
            throw new CLIProcessingException("Unable to fetch Cluster details.");
        }
        List<Object> inputHostList = new ArrayList();
        try {
            inputHostList = this.getHostList(inputNodeList, zkConnectString, out);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Error Fetching HostNames for nodes");
        }
        if (inputHostList.isEmpty()) {
            StringBuilder outputErrorParams = new StringBuilder(inputHostList.toString());
            if (outputErrorParams.length() > 60) {
                outputErrorParams.delete(61, outputErrorParams.length());
                outputErrorParams.append("...");
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "Input for nodes: " + outputErrorParams.toString() + " does not match the IP address or hostname of any cluster nodes"));
            LOG.error((Object)("Input for nodes: " + outputErrorParams.toString() + " does not match the IP address or hostname of any cluster nodes."));
            throw new CLIProcessingException("Input IP address or hostname does not match any cluster nodes");
        }
        Map<String, Common.ServiceData> insightServiceData = NodesCommonUtils.getServiceNodeData(zkConnectString, INSIGHT_PARAM, "");
        if (insightServiceData == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Insight Service not found on cluster"));
            throw new CLIProcessingException("Insight Service not found on cluster");
        }
        insightServiceData.remove("master");
        ArrayList<String> hostList = new ArrayList<String>();
        for (Common.ServiceData serviceData : insightServiceData.values()) {
            String host = null;
            if (serviceData.hasHost()) {
                host = serviceData.getHost();
            }
            if (host == null) continue;
            hostList.add(host);
        }
        for (String string : inputHostList) {
            if (hostList.contains(string)) continue;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Input host not found." + string));
            throw new CLIProcessingException("Insight Service not found on Host: " + string);
        }
        return inputHostList;
    }

    List<String> verifyTypes(List<String> inputTypesList, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        ArrayList<String> typeList = new ArrayList<String>();
        if (inputTypesList.size() > CLDBProto.InsightTypeConfig.InsightType.values().length) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Types count should be less than :" + CLDBProto.InsightTypeConfig.InsightType.values().length + "1"));
            throw new CLIProcessingException("Types count should be less than :" + CLDBProto.InsightTypeConfig.InsightType.values().length + "1");
        }
        for (String inputType : inputTypesList) {
            CLDBProto.InsightTypeConfig.InsightType matchedType = null;
            for (CLDBProto.InsightTypeConfig.InsightType type : CLDBProto.InsightTypeConfig.InsightType.values()) {
                if (!inputType.equalsIgnoreCase(type.name())) continue;
                matchedType = type;
                break;
            }
            if (matchedType == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Type not found: " + inputType));
                throw new CLIProcessingException("Type not found.");
            }
            typeList.add(matchedType.name());
        }
        if (inputTypesList.isEmpty()) {
            for (CLDBProto.InsightTypeConfig.InsightType type : CLDBProto.InsightTypeConfig.InsightType.values()) {
                typeList.add(type.name());
            }
        }
        return typeList;
    }

    List<String> prepareParamValueList(String PARAM) {
        ArrayList<String> valueList = new ArrayList<String>();
        List inputList = new ArrayList();
        if (this.isParamPresent(PARAM)) {
            inputList = this.input.getParameterByName(PARAM).getParamValues();
        }
        for (String input : inputList) {
            if (input.contains(",")) {
                valueList.addAll(Arrays.asList(input.split(",")));
                continue;
            }
            valueList.add(input);
        }
        return valueList;
    }

    void populateTypeConfig(List<String> inputTypeList, CLDBProto.InsightConfig.Builder config, boolean enabled) {
        block0: for (String type : inputTypeList) {
            CLDBProto.InsightTypeConfig.Builder typeBuilder = CLDBProto.InsightTypeConfig.newBuilder();
            for (CLDBProto.InsightTypeConfig.InsightType insightType : CLDBProto.InsightTypeConfig.InsightType.values()) {
                if (!type.equalsIgnoreCase(insightType.name())) continue;
                typeBuilder.setInsightType(insightType);
                typeBuilder.setEnabled(enabled);
                config.addTypeConfig(typeBuilder);
                continue block0;
            }
        }
    }

    List<CLDBProto.InsightTypeConfig.InsightType> prepareTypes(List<String> inputTypeList) {
        ArrayList<CLDBProto.InsightTypeConfig.InsightType> typeList = new ArrayList<CLDBProto.InsightTypeConfig.InsightType>();
        for (String typeStr : inputTypeList) {
            try {
                CLDBProto.InsightTypeConfig.InsightType type = CLDBProto.InsightTypeConfig.InsightType.valueOf((String)typeStr);
                typeList.add(type);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Invalid Type Found : " + typeStr), (Throwable)e);
            }
        }
        return typeList;
    }

    void populateConfig(CLDBProto.InsightConfigUpdateRequest.Builder req, List<String> inputNodeList, List<String> inputTypeList, boolean enabled, CommandOutput.OutputHierarchy out) {
        for (String host : inputNodeList) {
            CLDBProto.InsightConfig.Builder config = CLDBProto.InsightConfig.newBuilder();
            config.setNodeName(host);
            this.populateTypeConfig(inputTypeList, config, enabled);
            req.addInsightNodeConfig(config.build());
        }
    }

    CommandOutput processPurge() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.InsightPurgeRequest.Builder req = CLDBProto.InsightPurgeRequest.newBuilder();
        if (!this.isParamPresent(RETENTION_DAYS_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "retention days parameter is missing"));
            LOG.error((Object)"RETENTION_DAYS_PARAM Absent");
            return output;
        }
        int retention = this.getParamIntValue(RETENTION_DAYS_PARAM, 0);
        req.setRetentionDays(retention);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightPurgeProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightPurgeResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.InsightPurgeResponse resp = CLDBProto.InsightPurgeResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                out.addMessage("Set insight purge configuration Successfully. ");
                return output;
            }
            String errorMsg = "Unable to set purge config " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
            return output;
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Exception during set purge config " + e));
            throw new CLIProcessingException("CLIProcessingException " + e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during set purge config " + e.getMessage()));
            return output;
        }
    }

    public static String epochMillisToStr(long epochTimeMillis) {
        if (epochTimeMillis == 0L) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
        dateFormat.setTimeZone(TimeZone.getDefault());
        String formattedDateTime = dateFormat.format(new Date(epochTimeMillis));
        return formattedDateTime;
    }

    void processStatusOutput(boolean nodeOptionEn, boolean typeOptionEn, boolean purgeOptionEn, CLDBProto.InsightStatusResponse resp, CommandOutput.OutputHierarchy out) {
        boolean allOptionEn;
        List nodeStatusList = resp.getNodeStatusList();
        CLDBProto.InsightStatus purgeStatus = resp.getPurgeStatus();
        CommandOutput.OutputHierarchy.OutputNode status = new CommandOutput.OutputHierarchy.OutputNode("status");
        CommandOutput.OutputHierarchy.OutputNode nodes = new CommandOutput.OutputHierarchy.OutputNode(NODES_PARAM);
        CommandOutput.OutputHierarchy.OutputNode purge = new CommandOutput.OutputHierarchy.OutputNode(PURGE_PARAM);
        CommandOutput.OutputHierarchy.OutputNode cluster = new CommandOutput.OutputHierarchy.OutputNode(SETCONFIG_PARAM);
        String insightMode = resp.getInsightMode();
        String insightMaster = resp.getInsightMaster();
        String hmsMaster = resp.getHmsMaster();
        String zeppelinMaster = resp.getZeppelinMaster();
        int zeppelinPort = resp.getZeppelinPort();
        status.addChild(new CommandOutput.OutputHierarchy.OutputNode("insightMode", (Object)insightMode));
        status.addChild(new CommandOutput.OutputHierarchy.OutputNode("insightMaster", (Object)insightMaster));
        status.addChild(new CommandOutput.OutputHierarchy.OutputNode("hmsMaster", (Object)hmsMaster));
        status.addChild(new CommandOutput.OutputHierarchy.OutputNode("zeppelinMaster", (Object)zeppelinMaster));
        status.addChild(new CommandOutput.OutputHierarchy.OutputNode("zeppelinPort", zeppelinPort));
        status.addNode(cluster);
        boolean bl = allOptionEn = !nodeOptionEn && !typeOptionEn && !purgeOptionEn;
        if (!purgeOptionEn) {
            status.addNode(nodes);
        }
        if (allOptionEn || purgeOptionEn) {
            status.addNode(purge);
        }
        CLDBProto.InsightConfig clusterConfig = resp.getClusterConfig();
        for (CLDBProto.InsightTypeConfig typeConfig : clusterConfig.getTypeConfigList()) {
            cluster.addChild(new CommandOutput.OutputHierarchy.OutputNode(typeConfig.getInsightType().name().toLowerCase(), (Object)typeConfig.getEnabled()));
        }
        CommandOutput.OutputHierarchy.OutputNode purgeNode = new CommandOutput.OutputHierarchy.OutputNode(insightMaster);
        for (CLDBProto.InsightStatus nodeStatus : nodeStatusList) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode(nodeStatus.getNodeName());
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("enabled", (Object)nodeStatus.getConfigEnabled()));
            for (CLDBProto.InsightTypeStatus typeStatus : nodeStatus.getTypeStatusList()) {
                CommandOutput.OutputHierarchy.OutputNode insightType = new CommandOutput.OutputHierarchy.OutputNode(typeStatus.getInsightType().name().toLowerCase());
                CommandOutput.OutputHierarchy.OutputNode purgeInsightType = new CommandOutput.OutputHierarchy.OutputNode(typeStatus.getInsightType().name().toLowerCase());
                node.addChild(insightType);
                insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("running", (Object)typeStatus.getRunning()));
                if (typeStatus.hasStatus()) {
                    insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("status", typeStatus.getStatus()));
                }
                if (typeStatus.hasErrMsg()) {
                    insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("errorMsg", (Object)typeStatus.getErrMsg()));
                }
                if (typeStatus.hasLastCommitTime()) {
                    long epochTimeMillis = typeStatus.getLastCommitTime();
                    String formattedDateTime = InsightCommands.epochMillisToStr(epochTimeMillis);
                    insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastCommitTime", (Object)formattedDateTime));
                } else {
                    insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastCommitTime", (Object)""));
                }
                if (!nodeStatus.getNodeName().equals(resp.getInsightMaster())) continue;
                if (typeStatus.getLastExpiryAttemptTime() != 0L) {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("attemptTime", (Object)InsightCommands.epochMillisToStr(typeStatus.getLastExpiryAttemptTime())));
                } else {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("attemptTime", (Object)""));
                }
                if (typeStatus.getLastExpirySuccessTime() != 0L) {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("finishTime", (Object)InsightCommands.epochMillisToStr(typeStatus.getLastExpirySuccessTime())));
                } else {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("finishTime", (Object)""));
                }
                if (typeStatus.getLastExpirySnapEpochTime() != 0L) {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapsEpoch", (Object)InsightCommands.epochMillisToStr(typeStatus.getLastExpirySnapEpochTime())));
                } else {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapsEpoch", (Object)""));
                }
                purgeNode.addChild(purgeInsightType);
            }
            nodes.addChild(node);
        }
        purge.addChild(purgeNode);
        if (purgeStatus.hasPurgeConfig() && purgeStatus.getPurgeConfig().hasRetentionDays()) {
            purge.addChild(new CommandOutput.OutputHierarchy.OutputNode(RETENTION_DAYS_PARAM, purgeStatus.getPurgeConfig().getRetentionDays()));
        }
        out.addNode(status);
    }

    private CLDBProto.InsightDashboardQueryResponse fetchMasterHostInfo() {
        byte[] data = null;
        CLDBProto.InsightDashboardQueryRequest.Builder req = CLDBProto.InsightDashboardQueryRequest.newBuilder();
        CLDBProto.InsightDashboardQueryResponse resp = null;
        req.setCreds(this.getUserCredentials());
        req.setOpType(CLDBProto.InsightDashboardOpType.QUERY_LIST);
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightDashboardQueryProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightDashboardQueryResponse.class);
            if (data == null) {
                return null;
            }
            resp = CLDBProto.InsightDashboardQueryResponse.parseFrom((byte[])data);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception during get insight info status" + e.getMessage()));
        }
        return resp;
    }

    void processConfigQueriesOutput(List<ZeppManager.ZeppPara> configQueries, CommandOutput.OutputHierarchy out) {
        for (int i = 0; i < configQueries.size(); ++i) {
            CommandOutput.OutputHierarchy.OutputNode configQueriesStatus = new CommandOutput.OutputHierarchy.OutputNode();
            configQueriesStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("notebookId", (Object)configQueries.get((int)i).notebookId));
            configQueriesStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("paragraphId", (Object)configQueries.get((int)i).paraId));
            configQueriesStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("dashboardQueryId", configQueries.get((int)i).dashQueryId));
            configQueriesStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("configVersion", configQueries.get((int)i).configVer));
            configQueriesStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("title", (Object)configQueries.get((int)i).title));
            configQueriesStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("linkToParagraph", (Object)configQueries.get((int)i).embedUrl));
            configQueriesStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("queryDesc", (Object)configQueries.get((int)i).queryDesc));
            out.addNode(configQueriesStatus);
        }
    }

    void processZeppRunPara(CommandOutput.OutputHierarchy out, String nbPath, int queryId) {
        String statusStr;
        ParagraphResult result = this.zeppManager.runPara(nbPath, queryId);
        if (result == null) {
            String errMsg = "Null response received while running zeppelin paragraph";
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        if (this.isParamPresent(PARASTATUS_PARAM)) {
            LOG.info((Object)("Paragraph result: " + result));
        }
        int statusCode = -1;
        switch (statusStr = result.getStatus().toString()) {
            case "FINISHED": {
                statusCode = 0;
                break;
            }
            case "PENDING": {
                statusCode = 1;
                break;
            }
            case "RUNNING": {
                statusCode = 2;
                break;
            }
            case "ERROR": {
                statusCode = 3;
                break;
            }
            case "ABORT": {
                statusCode = 4;
                break;
            }
            case "READY": {
                statusCode = 5;
                break;
            }
            case "UNKNOWN": {
                statusCode = 6;
            }
        }
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode("statusCode", statusCode));
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode("statusStr", (Object)statusStr));
        out.addNode(output);
    }

    void configureZeppNb(CommandOutput.OutputHierarchy out, CLDBProto.InsightDashboardQueryResponse resp) {
        List<ZeppManager.ZeppPara> configQueries = this.zeppManager.configQueries(this.DEFAULT_ZEPP_NBPATH, resp);
        this.processConfigQueriesOutput(configQueries, out);
    }

    void executeZeppPara(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        int queryId = -1;
        String nbPath = "";
        if (!this.isParamPresent(QUERYID_PARAM)) {
            String errMsg = "Missing query id param";
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
            return;
        }
        queryId = this.getParamIntValue(QUERYID_PARAM, 0);
        nbPath = this.isParamPresent(NOTEBOOK_PARAM) ? this.getParamTextValue(NOTEBOOK_PARAM, 0) : this.DEFAULT_ZEPP_NBPATH;
        this.processZeppRunPara(out, nbPath, queryId);
    }

    CommandOutput processDashboardQuery() throws CLIProcessingException {
        CommandOutput output;
        block21: {
            output = new CommandOutput();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            if (!this.isValidParamCombination(out)) {
                return output;
            }
            if (this.isParamPresent(CONFIGURE_PARAM) || this.isParamPresent(RUN_PARAM)) {
                String jSessionId = "";
                int zeppelinPort = 9995;
                CLDBProto.InsightDashboardQueryResponse resp = this.fetchMasterHostInfo();
                if (resp == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                String hmsMaster = resp.getHmsMaster();
                if (hmsMaster.isEmpty() || hmsMaster == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "No active HiveMetaStore found. Cannot configure spark interpreter without HMS."));
                    return output;
                }
                String sparkMaster = resp.getSparkMaster();
                if (sparkMaster.isEmpty() || sparkMaster == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "No active spark master found. Cannot configure spark interpreter without spark."));
                    return output;
                }
                String zeppMaster = resp.getZeppelinMaster();
                if (this.isParamPresent(ZEPPELIN_PARAM)) {
                    zeppMaster = this.getParamTextValue(ZEPPELIN_PARAM, 0);
                }
                if (zeppMaster.isEmpty() || zeppMaster == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(-1, "No active zeppelin master found."));
                    return output;
                }
                zeppelinPort = resp.getZeppelinPort();
                this.zeppManager = new ZeppManager(zeppMaster, hmsMaster, sparkMaster, zeppelinPort);
                if (!this.isParamPresent(JSESSIONID_PARAM)) {
                    String errMsg = "jsessionid parameter is missing.";
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
                    return output;
                }
                jSessionId = this.getParamTextValue(JSESSIONID_PARAM, 0);
                int setUpSession = this.zeppManager.setupSession(jSessionId, null, null);
                if (setUpSession != 0) {
                    String errMsg = setUpSession == -1 ? "Invalid JSESSIONID." : "Could not connect to the Zeppelin server.";
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Unable to set up session with Zeppelin. " + errMsg));
                    return output;
                }
                int configSparkInterpreter = this.zeppManager.configInterpreter();
                if (configSparkInterpreter != 0) {
                    String errMsg = "Failed to configure spark interpreter.";
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, errMsg));
                    return output;
                }
                if (this.isParamPresent(CONFIGURE_PARAM)) {
                    this.configureZeppNb(out, resp);
                    return output;
                }
                if (this.isParamPresent(RUN_PARAM)) {
                    this.executeZeppPara(out);
                    return output;
                }
            }
            CLDBProto.InsightDashboardQueryRequest.Builder req = CLDBProto.InsightDashboardQueryRequest.newBuilder();
            int queryId = -1;
            req.setOpType(CLDBProto.InsightDashboardOpType.ENABLE);
            if (!this.isParamPresent(ENABLE_PARAM)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specify either of the param: -configure / -run / -enable \n" + dashboardCommand.getUsageOfOnlyThisCommand()));
                return output;
            }
            boolean enable = this.getParamBooleanValue(ENABLE_PARAM, 0);
            req.setEnabled(enable);
            if (this.isParamPresent(ID_PARAM)) {
                queryId = this.getParamIntValue(ID_PARAM, 0);
            }
            req.setId(queryId);
            byte[] data = null;
            try {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightDashboardQueryProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightDashboardQueryResponse.class);
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.InsightDashboardQueryResponse resp = CLDBProto.InsightDashboardQueryResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    if (this.getParamBooleanValue(ENABLE_PARAM, 0)) {
                        out.addMessage("Query enabled successfully.");
                    } else {
                        out.addMessage("Query disabled successfully.");
                    }
                    break block21;
                }
                String errorMsg = "Unable to enable/disable the query. " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
                return output;
            }
            catch (CLIProcessingException e) {
                LOG.error((Object)("Exception during processing dashboard query. " + e));
                throw new CLIProcessingException("CLIProcessingException " + e);
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                LOG.error((Object)("Exception processing dashboard query. " + e.getMessage()));
            }
        }
        return output;
    }

    List<String> getHostList(List<String> nodeHostNames, String zkConnectString, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        List<String> nodes = NodesCommonUtils.findNodeIps(zkConnectString, "");
        if (nodeHostNames == null || nodeHostNames.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "No nodes matched input parameters"));
            throw new CLIProcessingException("No nodes matched input parameters");
        }
        List<String> nodeNames = NodesCommonUtils.convertHostToIpIncludingLocal(nodeHostNames);
        nodeNames.addAll(NodesCommonUtils.convertIpToHost(nodeHostNames));
        nodeNames.addAll(nodeHostNames);
        HashSet<String> nodeNamesSet = new HashSet<String>(nodeNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NodeNamesSet: " + nodeNamesSet));
        }
        nodeNamesSet.removeAll(nodes);
        nodeNames.removeAll(nodeNamesSet);
        HashSet<String> nodeNamesUnique = new HashSet<String>(nodeNames);
        ArrayList<String> UniqueHostList = new ArrayList<String>(nodeNamesUnique);
        return UniqueHostList;
    }
}

