/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.cli.DbCommands;
import com.mapr.cli.DbReplicaCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Error;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.tables.TableProperties;
import com.mapr.fs.util.Fids;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.ojai.FieldPath;

public class DbIndexCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbReplicaCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String INDEX_PARAM_NAME = "index";
    private static final String INDEX_NAME_PARAM_NAME = "indexname";
    private static final String INDEX_FIELD_PARAM_NAME = "indexedfields";
    private static final String NONINDEX_FIELD_PARAM_NAME = "includedfields";
    private static final String HASHED_INDEX_PARAM_NAME = "hashed";
    private static final String NUM_HASH_PARTITIONS_PARAM_NAME = "numhashpartitions";
    private static final String REFRESH_PARAM_NAME = "refreshnow";
    private static final String DETAILS_PARAM_NAME = "details";
    private static final int DEFAULT_NUM_HASH_PARTITIONS = 10;
    private static final CLICommand listCommand = new CLICommand("list", "usage: table index list -path <tablepath> -refreshnow <statsrefresh>", DbIndexCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"refreshnow", (Object)new BooleanInputParameter("refreshnow", "refreshnow", false, Boolean.valueOf(false))).put((Object)"indexname", (Object)new TextInputParameter("indexname", "index name", false, null)).put((Object)"details", (Object)new BooleanInputParameter("details", "refreshnow", false, Boolean.valueOf(false)).setInvisible(true)).build(), null).setShortUsage("table index list -path <tablepath>");
    private static final CLICommand addCommand = new CLICommand("add", "usage: table index add -path <tablePath> -index <indexName> -indexedfields '<fieldpath1: 1/-1 | ASC/DESC | asc/desc, fieldpath2>' [-includedfields 'fieldpath3, fieldpath4'] [-hashed <true | false, default = false>] [-numhashpartitions <numHashPartitions, default = 10 when 'hashed' = true>]", DbIndexCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "index name", true, null)).put((Object)"indexedfields", (Object)new TextInputParameter("indexedfields", "indexed field name, <fieldpath1: 1/-1 | ASC/DESC | asc/desc, $CAST(fieldpath2@INT)>", true, null)).put((Object)"includedfields", (Object)new TextInputParameter("includedfields", "included field name, <fieldpath3, fieldpath4>", false, null)).put((Object)"hashed", (Object)new BooleanInputParameter("hashed", "hashed index enabled", false, Boolean.valueOf(false))).put((Object)"numhashpartitions", (Object)new IntegerInputParameter("numhashpartitions", "number of hash index partitions when hashed index enabled", false, null)).build(), null).setShortUsage("table index add -path <tablePath> -index <indexName>");
    private static final CLICommand removeCommand = new CLICommand("remove", "usage: table index remove -path <tablepath> -index <indexName>", DbIndexCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "index name", true, null)).build(), null).setShortUsage("table index remove -path <tablepath> -index <indexName>");
    private static final CLICommand editCommand = new CLICommand("edit", "usage: table index edit -path <tablePath> -index <indexName> -numhashpartitions <numberOfHashPartitions>", DbIndexCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "index name", true, null)).put((Object)"numhashpartitions", (Object)new TextInputParameter("numhashpartitions", "number of hash index partitions when hashed index enabled", true, null)).build(), null).setShortUsage("table index edit -path <tablePath> -index <indexName> -numhashpartitins <numHashPartitions>");
    public static final CLICommand indexCommands = new CLICommand("index", "index [add|remove|list]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCommand, removeCommand, listCommand}).setShortUsage("table index [add|remove|list]");

    public DbIndexCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cname = this.cliCommand.getCommandName();
        if (cname.equalsIgnoreCase(addCommand.getCommandName())) {
            this.addIndex(out);
        } else if (cname.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listIndex(out);
        } else if (cname.equalsIgnoreCase(removeCommand.getCommandName())) {
            this.removeIndex(out);
        }
        return output;
    }

    private String bytesToString(ByteString bstr) {
        return BinaryString.toStringBinary((byte[])bstr.toByteArray());
    }

    private ByteString stringToByteString(String raws) {
        byte[] bArr = BinaryString.toBytesBinary((String)raws);
        return ByteString.copyFrom((byte[])bArr);
    }

    public String entityName() {
        return "table";
    }

    protected void addIndex(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String indexName = this.getParamTextValue(INDEX_PARAM_NAME, 0);
        final String idxField = this.getParamTextValue(INDEX_FIELD_PARAM_NAME, 0);
        final String nonidxField = this.isParamPresent(NONINDEX_FIELD_PARAM_NAME) ? this.getParamTextValue(NONINDEX_FIELD_PARAM_NAME, 0) : null;
        final boolean isHashed = this.isParamPresent(HASHED_INDEX_PARAM_NAME) ? this.getParamBooleanValue(HASHED_INDEX_PARAM_NAME, 0) : false;
        final int numHashPartitions = this.isParamPresent(NUM_HASH_PARTITIONS_PARAM_NAME) ? this.getParamIntValue(NUM_HASH_PARTITIONS_PARAM_NAME, 0) : 10;
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        final DbIndexCommands dbPerm = this;
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    Path path = new Path(tablePath);
                    if (DbIndexCommands.this.isParamPresent(DbIndexCommands.NUM_HASH_PARTITIONS_PARAM_NAME) && !isHashed) {
                        throw new CLIProcessingException("numhashpartitions cannot be set for Range Partitioned Index");
                    }
                    if (!mfs.isTable(path)) {
                        throw new CLIProcessingException("Table not found. Path: " + tablePath);
                    }
                    if (!mfs.isJsonTable(new Path(tablePath))) {
                        throw new IOException("index not supported for binary table " + tablePath);
                    }
                    TableProperties props = mfs.getTableProperties(path);
                    DbIndexCommands.setupIndex(dbPerm, replBuilder, tablePath, indexName, idxField, nonidxField, isHashed, numHashPartitions, DbIndexCommands.this.getUserLoginId(), mfs);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    protected void removeIndex(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        final String indexName = this.getParamTextValue(INDEX_PARAM_NAME, 0);
        final Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder();
        DbIndexCommands dbPerm = this;
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        replBuilder.setReplicaClassName(Dbserver.DBInternalDefaults.getDefaultInstance().getReplicaClassNameForSIndex());
                        replBuilder.setSiInfo(Dbserver.SIndexInfo.newBuilder().setIndexName(indexName));
                        Dbserver.TableReplicaDesc replDesc = replBuilder.build();
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Primary table not found. Path: " + tablePath);
                        }
                        if (!mfs.isJsonTable(new Path(tablePath))) {
                            throw new IOException("index not supported for binary table " + tablePath);
                        }
                        mfs.removeTableReplica(new Path(tablePath), replDesc);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    protected void listIndex(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        String indexName = this.isParamPresent(INDEX_NAME_PARAM_NAME) ? this.getParamTextValue(INDEX_NAME_PARAM_NAME, 0) : null;
        final boolean refreshNow = this.isParamPresent(REFRESH_PARAM_NAME) ? this.getParamBooleanValue(REFRESH_PARAM_NAME, 0) : false;
        boolean details = this.isParamPresent(DETAILS_PARAM_NAME) ? this.getParamBooleanValue(DETAILS_PARAM_NAME, 0) : false;
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        final ArrayList rlist = new ArrayList();
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        boolean foundIndex = false;
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    try {
                        if (!mfs.isTable(new Path(tablePath))) {
                            throw new CLIProcessingException("Table not found. Path: " + tablePath);
                        }
                        if (!mfs.isJsonTable(new Path(tablePath))) {
                            throw new IOException("index not supported for binary table " + tablePath);
                        }
                        Dbserver.TableReplicaListResponse resp = mfs.listTableIndexes(new Path(tablePath), true, true, refreshNow);
                        rlist.add(resp);
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw new CLIProcessingException(e.getMessage());
                    }
                }
            };
            List<Dbserver.ColumnFamilyAttr> familyAttrs = DbReplicaCommands.getAllFamilies(tablePath, this.getUserLoginId());
            Dbserver.TableReplicaListResponse listResp = (Dbserver.TableReplicaListResponse)rlist.get(0);
            for (Dbserver.TableReplicaDesc rd : listResp.getReplicasList()) {
                if (indexName != null && !rd.getSiInfo().getIndexName().equals(indexName)) continue;
                foundIndex = true;
                CommandOutput.OutputHierarchy.OutputNode replNode = new CommandOutput.OutputHierarchy.OutputNode();
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)rd.getClusterName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("type", (Object)rd.getReplicaClassName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("indexFid", (Object)String.valueOf(rd.getSiInfo().getIndexFid().getCid() + "." + String.valueOf(rd.getSiInfo().getIndexFid().getCinum() + "." + String.valueOf(rd.getSiInfo().getIndexFid().getUniq())))));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("indexName", (Object)rd.getSiInfo().getIndexName()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(HASHED_INDEX_PARAM_NAME, (Object)rd.getSiInfo().getHashed()));
                if (rd.getSiInfo().getHashed()) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numHashPartitions", rd.getSiInfo().getHashingInfo().getHashConfig(0).getNumPartitions()));
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("indexState", (Object)rd.getRstate().toString()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", rd.getIdx()));
                Object Field2 = "";
                for (Dbserver.SIndexInfo.FieldInfo fi : rd.getSiInfo().getIndexedFieldsList()) {
                    FieldPath fp = null;
                    String[] cfQual = fi.getFieldPath(0).split(":", 2);
                    String famName = DbReplicaCommands.familyIdToName(familyAttrs, Integer.parseInt(cfQual[0]));
                    fp = MapRDBTableImplHelper.cfQualifierToJsonPath((String)famName, (String)cfQual[1], familyAttrs);
                    if (fi.getMapInfo().getType() == Dbserver.SIndexInfo.MappingType.NONE) {
                        Field2 = (String)Field2 + (((String)Field2).isEmpty() ? "" : ", ") + fp.asPathString(false) + (String)(details ? "," + fi.getFieldPathIdx(0) : "") + ":" + fi.getSortOrder();
                        continue;
                    }
                    if (fi.getMapInfo().getCastType() == Dbserver.SIndexInfo.CastType.STRING) {
                        Field2 = (String)Field2 + (((String)Field2).isEmpty() ? "" : ", ") + "$" + fi.getMapInfo().getType() + " " + fp.asPathString(false) + " AS:" + fi.getMapInfo().getCastType() + "(" + (fi.getMapInfo().getCastStringLength() - 1) + ")" + (String)(details ? "," + fi.getFieldPathIdx(0) : "") + ":" + fi.getSortOrder();
                        continue;
                    }
                    Field2 = (String)Field2 + (((String)Field2).isEmpty() ? "" : ", ") + "$" + fi.getMapInfo().getType() + " " + fp.asPathString(false) + " AS:" + fi.getMapInfo().getCastType() + (String)(details ? "," + fi.getFieldPathIdx(0) : "") + ":" + fi.getSortOrder();
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("indexedFields", Field2));
                Field2 = "";
                if (rd.getSiInfo().getNonindexedFieldsCount() != 0) {
                    for (Dbserver.SIndexInfo.FieldInfo fi : rd.getSiInfo().getNonindexedFieldsList()) {
                        String[] cfQual = fi.getFieldPath(0).split(":", 2);
                        String famName = DbReplicaCommands.familyIdToName(familyAttrs, Integer.parseInt(cfQual[0]));
                        FieldPath fp = MapRDBTableImplHelper.cfQualifierToJsonPath((String)famName, (String)cfQual[1], familyAttrs);
                        Field2 = (String)Field2 + (((String)Field2).isEmpty() ? "" : ", ") + fp.asPathString(false) + (String)(details ? "," + fi.getFieldPathIdx(0) : "");
                    }
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("includedFields", Field2));
                }
                long minPendingTS = 0L;
                long maxPendingTS = 0L;
                long bytesPending = 0L;
                long putsPending = 0L;
                int bucketsPending = 0;
                int asyncBuckets = 0;
                int copyTableCompletionPct = 0;
                ArrayList<Error.ExtendedError> elist = null;
                for (Dbserver.TableReplicaStatus rs : listResp.getReplicaStatusList()) {
                    if (rd.getIdx() != rs.getReplicaIdx()) continue;
                    minPendingTS = rs.getMinPendingTS();
                    maxPendingTS = rs.getMaxPendingTS();
                    bytesPending = rs.getBytesPending();
                    putsPending = rs.getPutsPending();
                    bucketsPending = rs.getBucketsPending();
                    asyncBuckets = rs.getAsyncBuckets();
                    copyTableCompletionPct = rs.getCopyTableCompletionPct();
                    for (Error.ExtendedError ee : rs.getEerrorsList()) {
                        if (elist == null) {
                            elist = new ArrayList<Error.ExtendedError>();
                        }
                        elist.add(ee);
                    }
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("isUptodate", (Object)(bucketsPending == 0 && !rd.getIsPaused() ? 1 : 0)));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("minPendingTS", minPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxPendingTS", maxPendingTS));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bytesPending", bytesPending));
                if (this.entityName().equals("table")) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("putsPending", putsPending));
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketsPending", bucketsPending));
                byte[] uuid = rd.getTableUuid().toByteArray();
                if (uuid.length != 0) {
                    replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString((byte[])uuid)));
                }
                if (rd.getRstate() == Dbserver.TableReplicaState.REPLICA_STATE_REPLICATING) {
                    copyTableCompletionPct = 100;
                }
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("copyTableCompletionPercentage", copyTableCompletionPct));
                Dbserver.TableBasicStats tableStats = mfs.getTableStats(new Path(tablePath), Fids.fidToString((Common.FidMsg)rd.getSiInfo().getIndexFid()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numTablets", tableStats.getNumTablets()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numRows", tableStats.getNumRows()));
                replNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalSize", tableStats.getSize()));
                if (elist != null) {
                    for (Error.ExtendedError ee : elist) {
                        CommandOutput.OutputHierarchy.OutputNode errNodes = new CommandOutput.OutputHierarchy.OutputNode("errors");
                        replNode.addChild(errNodes);
                        if (ee.hasEcode()) {
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Code", (Object)ee.getEcode().name()));
                        }
                        if (ee.hasEhost()) {
                            CLDBRpcCommonUtils.IpAddr ipAddr = new CLDBRpcCommonUtils.IpAddr();
                            if (ee.hasEhostIpAddr()) {
                                ipAddr.copyFrom(ee.getEhostIpAddr());
                            } else {
                                ipAddr.copyFrom(Integer.valueOf(ee.getEhost()));
                            }
                            errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Host", (Object)ipAddr.toString()));
                        }
                        if (!ee.hasEmsg()) continue;
                        errNodes.addChild(new CommandOutput.OutputHierarchy.OutputNode("Msg", (Object)ee.getEmsg()));
                    }
                }
                out.addNode(replNode);
            }
            if (!foundIndex && indexName != null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, tablePath + " does not have an index named '" + indexName + "'"));
                return;
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private static boolean containsNestedField(FieldPath inFP, Set<FieldPath> fpSet) throws CLIProcessingException {
        for (FieldPath fp : fpSet) {
            if (!fp.isAtOrBelow(inFP) && !fp.isAtOrAbove(inFP)) continue;
            throw new CLIProcessingException("Nested indexed fields " + inFP.asPathString() + " and " + fp.asPathString() + " not allowed for same Index");
        }
        return false;
    }

    public static void setupIndex(AceHelper.DBPermission dbPerm, Dbserver.TableReplicaDesc.Builder replBuilder, String tablePath, String indexName, String idxField, String nonidxField, boolean isHashed, int numHashPartitions, String user, MapRFileSystem mfs) throws CLIProcessingException, IOException {
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(user);
        try {
            boolean isArrayField;
            TableProperties tableProp = mfs.getTableProperties(new Path(tablePath));
            if (tableProp.getUuid() == null || tableProp.getUuid().length == 0) {
                throw new IOException("Table " + tablePath + " does not have a uuid. Set replperm and retry operation");
            }
            replBuilder.setReplicaClassName(Dbserver.DBInternalDefaults.getDefaultInstance().getReplicaClassNameForSIndex());
            Path tpath = new Path(tablePath);
            String clusterName = mfs.getClusterName(tpath.toUri());
            replBuilder.setClusterName(clusterName);
            replBuilder.setRstate(Dbserver.TableReplicaState.REPLICA_STATE_WAIT_TILL_BULKLOAD);
            Dbserver.SIndexInfo.Builder siBuilder = Dbserver.SIndexInfo.newBuilder();
            String[] fields = idxField.split("\\s*,\\s*");
            HashSet<Object> indexSet = new HashSet<Object>();
            HashSet<FieldPath> indexFPSet = new HashSet<FieldPath>();
            boolean isArrayIndex = false;
            for (String field : fields) {
                List familyAttrs;
                Dbserver.SIndexInfo.SIndexOrder od;
                String order;
                Dbserver.SIndexInfo.MappingInfo.Builder mInfo;
                String fd;
                block76: {
                    fd = null;
                    mInfo = null;
                    isArrayField = false;
                    try {
                        String function;
                        if (field.charAt(0) != '$') {
                            fd = !field.contains(":") ? field : (field.charAt(field.lastIndexOf(":") - 1) == '\\' ? new StringBuilder(field).deleteCharAt(field.lastIndexOf("\\")).toString() : field.substring(0, field.lastIndexOf(":")));
                            FieldPath fp = FieldPath.parseFrom((String)fd);
                            if (indexSet.contains(fd)) {
                                throw new CLIProcessingException("cannot take same field multiple times");
                            }
                            if (!DbIndexCommands.containsNestedField(fp, indexFPSet)) {
                                indexSet.add(fd);
                                indexFPSet.add(fp);
                            }
                            if (fd.equals("_id")) {
                                throw new CLIProcessingException("_id can not be added as part of the index");
                            }
                            DbIndexCommands.verifySingleFieldPath(fd);
                            if (fd.indexOf("[]") > 0) {
                                isArrayIndex = true;
                                isArrayField = true;
                            }
                            mInfo = Dbserver.SIndexInfo.MappingInfo.newBuilder().setType(Dbserver.SIndexInfo.MappingType.NONE);
                            break block76;
                        }
                        String systemField = field.substring(field.indexOf("$") + 1);
                        switch (function = systemField.substring(0, systemField.indexOf("(")).trim()) {
                            case "CAST": {
                                String castType;
                                fd = field.substring(field.indexOf("(") + 1, field.indexOf("@")).trim();
                                if (fd.equals("_id")) {
                                    throw new CLIProcessingException("_id can not be added as part of the index");
                                }
                                if (fd.indexOf("[]") > 0) {
                                    isArrayIndex = true;
                                    isArrayField = true;
                                }
                                if (indexSet.contains(fd + "@" + (castType = field.substring(field.indexOf("@") + 1, field.indexOf(")")).trim()))) {
                                    throw new CLIProcessingException("cannot take same field multiple times");
                                }
                                indexSet.add(fd + "@" + castType);
                                Dbserver.SIndexInfo.CastType cType = null;
                                int castStringLength = 0;
                                switch (castType) {
                                    case "STRING": {
                                        cType = Dbserver.SIndexInfo.CastType.STRING;
                                        break;
                                    }
                                    case "INT": {
                                        cType = Dbserver.SIndexInfo.CastType.INT;
                                        break;
                                    }
                                    case "BOOLEAN": {
                                        cType = Dbserver.SIndexInfo.CastType.BOOLEAN;
                                        break;
                                    }
                                    case "DOUBLE": {
                                        cType = Dbserver.SIndexInfo.CastType.DOUBLE;
                                        break;
                                    }
                                    case "LONG": {
                                        cType = Dbserver.SIndexInfo.CastType.LONG;
                                        break;
                                    }
                                    case "FLOAT": {
                                        cType = Dbserver.SIndexInfo.CastType.FLOAT;
                                        break;
                                    }
                                    case "DATE": {
                                        cType = Dbserver.SIndexInfo.CastType.DATE;
                                        break;
                                    }
                                    case "TIME": {
                                        cType = Dbserver.SIndexInfo.CastType.TIME;
                                        break;
                                    }
                                    case "TIMESTAMP": {
                                        cType = Dbserver.SIndexInfo.CastType.TIMESTAMP;
                                        break;
                                    }
                                    case "SHORT": 
                                    case "BINARY": 
                                    case "INTERVAL": {
                                        throw new CLIProcessingException("Casting to " + castType + " is not supported");
                                    }
                                    default: {
                                        if (castType.substring(0, 7).equals("STRING(")) {
                                            String stringLengthStr = castType.substring(7);
                                            try {
                                                castStringLength = Integer.parseInt(stringLengthStr);
                                            }
                                            catch (NumberFormatException nfe) {
                                                throw new CLIProcessingException("String length is not a number");
                                            }
                                            if (castStringLength < 1 || castStringLength > 255) {
                                                throw new CLIProcessingException("String length must be between 1 and 255");
                                            }
                                            cType = Dbserver.SIndexInfo.CastType.STRING;
                                            break;
                                        }
                                        throw new CLIProcessingException("Invalid Cast type: " + castType);
                                    }
                                }
                                mInfo = Dbserver.SIndexInfo.MappingInfo.newBuilder().setType(Dbserver.SIndexInfo.MappingType.CAST).setCastType(cType);
                                if (castStringLength != 0) {
                                    mInfo.setCastStringLength(castStringLength + 1);
                                }
                                break;
                            }
                            default: {
                                throw new CLIProcessingException("Index field in " + field + " is not valid");
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new CLIProcessingException("Index Field in " + field + " format not properly given");
                    }
                }
                try {
                    order = field.contains(":") && field.charAt(field.lastIndexOf(":") - 1) == '\\' ? field : field.substring(field.lastIndexOf(58) + 1).trim();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new CLIProcessingException("Index Order in" + field + "not properly given");
                }
                if (order.equals("-1") || order.equals("DESC") || order.equals("desc")) {
                    od = Dbserver.SIndexInfo.SIndexOrder.DESC;
                } else if (order.equals("1") || order.equals("ASC") || order.equals("asc") || order.equals(field)) {
                    od = Dbserver.SIndexInfo.SIndexOrder.ASC;
                } else {
                    throw new CLIProcessingException(order + "is not correctly formatted");
                }
                Object finalPath = "";
                try {
                    familyAttrs = mfs.listColumnFamily(tpath, false);
                }
                catch (IOException e) {
                    throw new CLIProcessingException(e.getMessage());
                }
                Dbserver.Qualifier.Builder fpQualBuilder = null;
                String[] qual = MapRDBTableImplHelper.jsonPathToCfQualifier((String)fd, (List)familyAttrs).split(":", 2);
                int cfId = 0;
                for (Dbserver.ColumnFamilyAttr cf : familyAttrs) {
                    if (!cf.getSchFamily().getName().equals(qual[0])) continue;
                    cfId = cf.getSchFamily().getId();
                    finalPath = Integer.toString(cfId) + ":" + qual[1];
                    break;
                }
                fpQualBuilder = Dbserver.Qualifier.newBuilder().setFamily(cfId).addQualifiers(ByteString.copyFromUtf8((String)qual[1]));
                Dbserver.SIndexInfo.FieldInfo.Builder fieldInfo = Dbserver.SIndexInfo.FieldInfo.newBuilder();
                fieldInfo.addFieldPath((String)finalPath).addIsArrayField(isArrayField).setSortOrder(od).setUpdateTimestamp(false);
                if (fpQualBuilder != null) {
                    fieldInfo.addFieldPathQualifier(fpQualBuilder);
                }
                if (mInfo != null) {
                    fieldInfo.setMapInfo(mInfo);
                }
                siBuilder.addIndexedFields(fieldInfo);
            }
            HashSet<String> includedSet = new HashSet<String>();
            if (nonidxField != null) {
                for (String field : fields = nonidxField.split(",")) {
                    List familyAttrs;
                    String nonfield;
                    isArrayField = false;
                    try {
                        nonfield = field;
                        if (includedSet.contains(nonfield)) {
                            throw new CLIProcessingException("cannot take same field multiple times");
                        }
                        if (!field.contains("[]") && indexSet.contains(field)) {
                            throw new CLIProcessingException("cannot take same non-array index and included field");
                        }
                        includedSet.add(nonfield);
                        if (nonfield.equals("_id")) {
                            throw new CLIProcessingException("_id can not be added as part of the index");
                        }
                        DbIndexCommands.verifySingleFieldPath(nonfield);
                        if (nonfield.indexOf("[]") > 0) {
                            isArrayIndex = true;
                            isArrayField = true;
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new CLIProcessingException("Included Field in " + field + " are not properly double quoted");
                    }
                    Object finalPath = "";
                    try {
                        familyAttrs = mfs.listColumnFamily(tpath, false);
                    }
                    catch (IOException e) {
                        throw new CLIProcessingException(e.getMessage());
                    }
                    int numCFimpacted = 0;
                    for (Dbserver.ColumnFamilyAttr cfAttr : familyAttrs) {
                        FieldPath cfJsonPath;
                        FieldPath inclFP = FieldPath.parseFrom((String)field);
                        if (!inclFP.isAtOrAbove(cfJsonPath = FieldPath.parseFrom((String)cfAttr.getJsonFamilyPath()))) continue;
                        ++numCFimpacted;
                    }
                    if (numCFimpacted > 1) {
                        throw new CLIProcessingException("Data for included field " + field + " may not span more than one column family.");
                    }
                    String[] qual = MapRDBTableImplHelper.jsonPathToCfQualifier((String)nonfield, (List)familyAttrs).split(":", 2);
                    int cfId = 0;
                    for (Dbserver.ColumnFamilyAttr cf : familyAttrs) {
                        if (!cf.getSchFamily().getName().equals(qual[0])) continue;
                        cfId = cf.getSchFamily().getId();
                        finalPath = Integer.toString(cfId) + ":" + qual[1];
                        break;
                    }
                    Dbserver.Qualifier.Builder fpQualBuilder = Dbserver.Qualifier.newBuilder().setFamily(cfId).addQualifiers(ByteString.copyFromUtf8((String)qual[1]));
                    siBuilder.addNonindexedFields(Dbserver.SIndexInfo.FieldInfo.newBuilder().addFieldPath((String)finalPath).addFieldPathQualifier(fpQualBuilder).addIsArrayField(isArrayField));
                }
            }
            siBuilder.setIsArrayIndex(isArrayIndex);
            siBuilder.setVersion(Dbserver.SIndexInfo.Version.v6dot1);
            siBuilder.setHashed(isHashed);
            siBuilder.setIsFullIndex(true);
            if (isHashed) {
                Fileserver.HashIndexInfo.HashConfig.Builder hashConfig = Fileserver.HashIndexInfo.HashConfig.newBuilder();
                hashConfig.setNumPartitions(numHashPartitions);
                Fileserver.HashIndexInfo.Builder hashInfo = Fileserver.HashIndexInfo.newBuilder();
                hashInfo.addHashConfig(hashConfig.build());
                hashInfo.setHashScheme(Fileserver.HashIndexInfo.Scheme.MURMUR_v2);
                siBuilder.setHashingInfo(hashInfo.build());
            }
            replBuilder.setSiInfo(siBuilder.setIndexName(indexName));
            Dbserver.TableReplicaDesc replDesc = replBuilder.build();
            mfs.addTableReplica(new Path(tablePath), replDesc, null);
            manager.moveToTop(tablePath);
        }
        catch (Exception e) {
            manager.deleteIfNotExist(tablePath, mfs);
            throw new CLIProcessingException(e.getMessage());
        }
    }

    private static void verifyIndexedFields(Set<String> indexSet) throws CLIProcessingException {
        int commonPrefixLen = 0;
        while (true) {
            boolean foundPrefix = false;
            Iterator<String> itr = indexSet.iterator();
            char ch = '\u0000';
            boolean firstPath = true;
            while (itr.hasNext()) {
                String s = itr.next();
                if (commonPrefixLen == s.length()) {
                    foundPrefix = true;
                    break;
                }
                if (firstPath) {
                    ch = s.charAt(commonPrefixLen);
                    firstPath = false;
                    continue;
                }
                if (ch == s.charAt(commonPrefixLen)) continue;
                foundPrefix = true;
                break;
            }
            if (foundPrefix) break;
            ++commonPrefixLen;
        }
        Iterator<String> itr = indexSet.iterator();
        int numOutstandingArrays = 0;
        while (itr.hasNext()) {
            String s = itr.next().substring(commonPrefixLen);
            int i = 0;
            while (i + 1 < s.length()) {
                if (s.charAt(i) == '[' && s.charAt(i + 1) == ']') {
                    ++numOutstandingArrays;
                }
                ++i;
            }
        }
        if (numOutstandingArrays > 1) {
            throw new CLIProcessingException("Cannot have more than one arrays as indexed fields");
        }
    }

    private static void verifySingleFieldPath(String fd) throws CLIProcessingException {
        try {
            FieldPath fieldPath = FieldPath.parseFrom((String)fd);
        }
        catch (Exception e) {
            throw new CLIProcessingException(e.getMessage());
        }
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key)) {
                ret = this.getParamTextValue(key, 0);
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

