/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.TextFormat;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.license.LicenseUtil;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.License;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LicenseCommands
extends CLIBaseClass {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy");
    private static final Logger LOG = Logger.getLogger(LicenseCommands.class);
    private static final String License = "license";
    private static final String IsFile = "is_file";
    private static final String CRL = "crl";
    private static final String LicenseId = "license_id";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    private static final CLICommand listCommand = new CLICommand("list", "usage: license list -cluster clustername", LicenseCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("license list -cluster clustername");
    private static final CLICommand appsCommand = new CLICommand("apps", "usage: license apps -cluster clustername", LicenseCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("license apps -cluster clustername");
    private static final CLICommand showIdCommand = new CLICommand("showid", "usage: license showid -cluster clustername", LicenseCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"showNodes", (Object)new BooleanInputParameter("showNodes", "show the total licensed nodes nodes available", false, Boolean.valueOf(false))).build(), null).setShortUsage("license showid -cluster clustername [-showNodes true|false]");
    private static final CLICommand addCommand = new CLICommand("add", "usage: license add -is_file [true|false] -license long_license_string -cluster clustername", LicenseCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"license", (Object)new TextInputParameter("license", "long_license_string", true, null)).put((Object)"is_file", (Object)new BooleanInputParameter("is_file", "true|false", false, Boolean.valueOf(false))).build(), null).setShortUsage("license add -is_file [true|false] -license long_license_string -cluster clustername");
    private static final CLICommand removeCommand = new CLICommand("remove", "usage: license remove -license_id id -cluster clustername", LicenseCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"license_id", (Object)new TextInputParameter("license_id", "id", true, null)).build(), null).setShortUsage("license remove -license_id id -cluster clustername");
    private static final CLICommand addCrlCommand = new CLICommand("addcrl", "usage: license addcrl -is_file [true|false] -crl crlstring -cluster clustername", LicenseCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"crl", (Object)new TextInputParameter("crl", "crlstring", true, null)).put((Object)"is_file", (Object)new BooleanInputParameter("is_file", "true|false", false, Boolean.valueOf(false))).build(), null).setShortUsage("license addcrl -is_file [true|false] -crl crlstring -cluster clustername");
    private static final CLICommand listCRLCommand = new CLICommand("listcrl", "usage: license listcrl -cluster clustername", LicenseCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("license listcrl -cluster clustername");
    public static final CLICommand licenseCommands = new CLICommand("license", "license [add|remove|list|showid|addcrl|listcrl]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{addCommand, removeCommand, listCommand, showIdCommand, appsCommand, addCrlCommand, listCRLCommand}).setShortUsage("license [add|remove|list|apps|showid|addcrl|listcrl]");

    public LicenseCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.isParamPresent("cluster")) {
            String cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return output;
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("add")) {
            this.addLicense(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            this.listLicenses(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            this.removeLicense(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("addcrl")) {
            this.addCRL(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("showid")) {
            this.showClusterID(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("apps")) {
            this.showCapabilities(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("listcrl")) {
            this.listCRLs(out);
        }
        return output;
    }

    public static License.LicenseIdResponse fetchClusterID(String cluster, Security.CredentialsMsg creds) throws CLIProcessingException {
        License.LicenseIdResponse resp = null;
        License.LicenseIdRequest req = License.LicenseIdRequest.newBuilder().setCreds(LicenseCommands.getLicenseCredentials(creds)).build();
        try {
            byte[] data = cluster != null && !cluster.isEmpty() ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetLicenseIdProc.getNumber(), (MessageLite)req, License.LicenseIdResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetLicenseIdProc.getNumber(), (MessageLite)req, License.LicenseIdResponse.class);
            if (data == null) {
                return null;
            }
            resp = License.LicenseIdResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception during fetch ClusterID", (Throwable)e);
            return null;
        }
        return resp;
    }

    private void showClusterID(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String cluster = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
        License.LicenseIdResponse licId = LicenseCommands.fetchClusterID(cluster, this.getUserCredentials());
        if (licId == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Show ClusterID: " + Errno.toString((int)10003)));
            return;
        }
        int status = licId.getStatus();
        if (status != 0) {
            String msg = licId.hasMessage() ? licId.getMessage() : Errno.toString((int)status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode id = new CommandOutput.OutputHierarchy.OutputNode();
        id.addChild(new CommandOutput.OutputHierarchy.OutputNode("id", (Object)licId.getClusterid()));
        if (this.getParamBooleanValue("showNodes", 0)) {
            id.addChild(new CommandOutput.OutputHierarchy.OutputNode("currentLicensedNodes", licId.getNodesUsed()));
            id.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxLicensedNodes", licId.getNodesTotal()));
        }
        out.addNode(id);
    }

    private String getLicenseString(boolean isFile, String lic) throws CLIProcessingException {
        if (!isFile) {
            return lic;
        }
        StringBuilder sb = new StringBuilder();
        FileReader reader = null;
        try {
            int len;
            reader = new FileReader(lic);
            char[] data = new char[1024];
            while ((len = reader.read(data)) != -1) {
                sb.append(data, 0, len);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new CLIProcessingException(fnfe.getMessage(), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new CLIProcessingException(ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    static License.LicenseCredentialsMsg getLicenseCredentials(Security.CredentialsMsg creds) {
        License.LicenseCredentialsMsg.Builder b = License.LicenseCredentialsMsg.newBuilder();
        b.setUid(creds.getUid());
        b.addAllGids((Iterable)creds.getGidsList());
        return b.build();
    }

    private void addLicense(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        License.AddLicenseResponse resp;
        String lic = this.getParamTextValue(License, 0);
        boolean file = this.getParamBooleanValue(IsFile, 0);
        try {
            String licenseStr = this.getLicenseString(file, lic);
            License.AddLicenseRequest.Builder b = License.AddLicenseRequest.newBuilder();
            b.setLicense(licenseStr);
            b.setCreds(LicenseCommands.getLicenseCredentials(this.getUserCredentials()));
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AddLicenseProc.getNumber(), (MessageLite)b.build(), License.AddLicenseResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AddLicenseProc.getNumber(), (MessageLite)b.build(), License.AddLicenseResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = License.AddLicenseResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "AddLicense: " + e.getMessage()));
            LOG.error((Object)"Exception during AddLicense", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasMessage() ? resp.getMessage() : Errno.toString((int)status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
        }
    }

    private void listLicenses(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        License.ShowLicenseResponse resp;
        License.ShowLicenseRequest.Builder b = License.ShowLicenseRequest.newBuilder();
        b.setAll(true);
        b.setCreds(LicenseCommands.getLicenseCredentials(this.getUserCredentials()));
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShowLicenseProc.getNumber(), (MessageLite)b.build(), License.ShowLicenseResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShowLicenseProc.getNumber(), (MessageLite)b.build(), License.ShowLicenseResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = License.ShowLicenseResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ShowLicense: " + e.getMessage()));
            LOG.error((Object)"Exception during AddLicense", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasMessage() ? resp.getMessage() : Errno.toString((int)status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
            return;
        }
        long time = System.currentTimeMillis();
        int now = (int)(time / 1000L);
        for (License.LicenseInfo lInfo : resp.getLicenseInfoList()) {
            CommandOutput.OutputHierarchy.OutputNode nfsClientNodesCount;
            CommandOutput.OutputHierarchy.OutputNode dData;
            String eFmt;
            Date date;
            CommandOutput.OutputHierarchy.OutputNode row = new CommandOutput.OutputHierarchy.OutputNode();
            out.addNode(row);
            CommandOutput.OutputHierarchy.OutputNode id = new CommandOutput.OutputHierarchy.OutputNode("id", (Object)lInfo.getHash());
            row.addChild(id);
            String desc = lInfo.getDescription();
            CommandOutput.OutputHierarchy.OutputNode d = new CommandOutput.OutputHierarchy.OutputNode("description", (Object)desc);
            row.addChild(d);
            if (lInfo.hasExpirationdate()) {
                long exp = lInfo.getExpirationdate();
                date = new Date(exp * 1000L);
                eFmt = dateFormat.format(date);
                dData = new CommandOutput.OutputHierarchy.OutputNode("expiry", (Object)eFmt);
                row.addChild(dData);
            }
            if (lInfo.hasIssuedate()) {
                long iss = lInfo.getIssuedate();
                date = new Date(iss * 1000L);
                eFmt = dateFormat.format(date);
                dData = new CommandOutput.OutputHierarchy.OutputNode("issue", (Object)eFmt);
                row.addChild(dData);
            }
            if (lInfo.hasModules()) {
                CommandOutput.OutputHierarchy.OutputNode dData2 = new CommandOutput.OutputHierarchy.OutputNode("modules", (Object)lInfo.getModules());
                row.addChild(dData2);
            }
            String nfsClientNodes = this.getMaxNfsClientNodes(lInfo, License.Feature.NFS_CLIENT, License.Feature.NFS_CLIENT_BASE, License.Feature.POSIX_CLIENT, License.Feature.POSIX_CLIENT_BASE);
            String goldNfsClientNodes = this.getMaxNfsClientNodes(lInfo, License.Feature.POSIX_CLIENT_GOLD);
            String platNfsClientNodes = this.getMaxNfsClientNodes(lInfo, License.Feature.POSIX_CLIENT_PLATINUM);
            if (!nfsClientNodes.equals("")) {
                nfsClientNodesCount = new CommandOutput.OutputHierarchy.OutputNode("posixnodes", (Object)nfsClientNodes);
                row.addChild(nfsClientNodesCount);
            } else if (!goldNfsClientNodes.equals("")) {
                nfsClientNodesCount = new CommandOutput.OutputHierarchy.OutputNode("goldposixnodes", (Object)goldNfsClientNodes);
                row.addChild(nfsClientNodesCount);
            } else if (!platNfsClientNodes.equals("")) {
                nfsClientNodesCount = new CommandOutput.OutputHierarchy.OutputNode("platinumposixnodes", (Object)platNfsClientNodes);
                row.addChild(nfsClientNodesCount);
            } else {
                String maxNodes = this.getMaxNodes(lInfo);
                CommandOutput.OutputHierarchy.OutputNode m = new CommandOutput.OutputHierarchy.OutputNode("maxnodes", (Object)maxNodes);
                row.addChild(m);
            }
            boolean additionalFeature = lInfo.getLicType().getNumber() == License.LicenseType.AdditionalFeatures.getNumber() || lInfo.getLicType().getNumber() == License.LicenseType.AdditionalFeaturesBase.getNumber();
            row.addChild(new CommandOutput.OutputHierarchy.OutputNode("isAdditionalFeature", (Object)additionalFeature));
            boolean deletable = lInfo.getLicType().getNumber() != License.LicenseType.Base.getNumber() && lInfo.getLicType().getNumber() != License.LicenseType.AdditionalFeaturesBase.getNumber();
            CommandOutput.OutputHierarchy.OutputNode del = new CommandOutput.OutputHierarchy.OutputNode("deletable", (Object)deletable);
            row.addChild(del);
            boolean grace = lInfo.getExpirationdate() < (long)now;
            CommandOutput.OutputHierarchy.OutputNode g = new CommandOutput.OutputHierarchy.OutputNode("grace", (Object)grace);
            row.addChild(g);
            String l = TextFormat.printToString((MessageOrBuilder)lInfo);
            CommandOutput.OutputHierarchy.OutputNode lic = new CommandOutput.OutputHierarchy.OutputNode(License, (Object)l);
            row.addChild(lic);
        }
    }

    private final String getMaxNfsClientNodes(License.LicenseInfo lInfo, License.Feature ... feature) {
        String m = "";
        List l = lInfo.getCapabilitiesList();
        block0: for (License.Capability c : l) {
            for (License.Feature f : feature) {
                if (c.getFeature().getNumber() != f.getNumber()) continue;
                m = c.getFeatureData().getMaxNfsClientNodes();
                continue block0;
            }
        }
        return m;
    }

    private final String getMaxNfsClientNodes(License.LicenseInfo lInfo) {
        String m = "";
        List l = lInfo.getCapabilitiesList();
        for (License.Capability c : l) {
            if (c.getFeature().getNumber() != License.Feature.NFS_CLIENT_BASE.getNumber() && c.getFeature().getNumber() != License.Feature.NFS_CLIENT.getNumber()) continue;
            m = c.getFeatureData().getMaxNfsClientNodes();
            break;
        }
        return m;
    }

    private final String getMaxNodes(License.LicenseInfo lInfo) {
        String m = "unlimited";
        List l = lInfo.getCapabilitiesList();
        for (License.Capability c : l) {
            if (c.getFeature().getNumber() != License.Feature.MAXNODES.getNumber()) continue;
            m = c.getFeatureData().getMaxNodes();
            break;
        }
        return m;
    }

    private void addCRL(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        License.AddCRLResponse resp;
        String crl = this.getParamTextValue(CRL, 0);
        boolean file = this.getParamBooleanValue(IsFile, 0);
        try {
            String hash;
            String crlStr = this.getLicenseString(file, crl);
            License.AddCRLRequest.Builder b = License.AddCRLRequest.newBuilder();
            b.setCrl(crlStr);
            b.setCreds(LicenseCommands.getLicenseCredentials(this.getUserCredentials()));
            boolean useSHA256 = false;
            try {
                hash = LicenseUtil.getHash((byte[])crlStr.getBytes("UTF-8"), (boolean)useSHA256);
            }
            catch (Exception e) {
                useSHA256 = true;
                hash = LicenseUtil.getHash((byte[])crlStr.getBytes("UTF-8"), (boolean)useSHA256);
            }
            b.setHash(hash);
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AddCRLProc.getNumber(), (MessageLite)b.build(), License.AddCRLResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AddCRLProc.getNumber(), (MessageLite)b.build(), License.AddCRLResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = License.AddCRLResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "AddCRL: " + e.getMessage()));
            LOG.error((Object)"Exception during AddCRL", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasMessage() ? resp.getMessage() : Errno.toString((int)status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
        }
    }

    private void listCRLs(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        License.ShowCRLResponse resp;
        License.ShowCRLRequest.Builder b = License.ShowCRLRequest.newBuilder();
        b.setAll(true);
        b.setCreds(LicenseCommands.getLicenseCredentials(this.getUserCredentials()));
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShowCRLProc.getNumber(), (MessageLite)b.build(), License.ShowCRLResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShowCRLProc.getNumber(), (MessageLite)b.build(), License.ShowCRLResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = License.ShowCRLResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ListCRL: " + e.getMessage()));
            LOG.error((Object)"Exception during listcrl", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasMessage() ? resp.getMessage() : Errno.toString((int)status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
            return;
        }
        this.dumpCRL(out, resp);
    }

    private String getCRLData(String s) {
        String data = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(s.getBytes("UTF-8"));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL c = (X509CRL)cf.generateCRL(bis);
            data = c.toString();
        }
        catch (Exception e) {
            data = "could not open CRL, skipping";
        }
        return data;
    }

    private void dumpCRL(CommandOutput.OutputHierarchy out, License.ShowCRLResponse resp) {
        ProtocolStringList crls = resp.getCrlsList();
        for (int i = 0; i < crls.size(); ++i) {
            CommandOutput.OutputHierarchy.OutputNode row = new CommandOutput.OutputHierarchy.OutputNode();
            out.addNode(row);
            CommandOutput.OutputHierarchy.OutputNode idx = new CommandOutput.OutputHierarchy.OutputNode("index", i);
            row.addChild(idx);
            String data = this.getCRLData((String)crls.get(i));
            CommandOutput.OutputHierarchy.OutputNode d = new CommandOutput.OutputHierarchy.OutputNode("data", (Object)data);
            row.addChild(d);
        }
    }

    private void removeLicense(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        License.RemoveLicenseResponse resp;
        String hash = this.getParamTextValue(LicenseId, 0);
        License.RemoveLicenseRequest.Builder b = License.RemoveLicenseRequest.newBuilder();
        b.setHash(hash);
        b.setCreds(LicenseCommands.getLicenseCredentials(this.getUserCredentials()));
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.RemoveLicenseProc.getNumber(), (MessageLite)b.build(), License.RemoveLicenseResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.RemoveLicenseProc.getNumber(), (MessageLite)b.build(), License.RemoveLicenseResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = License.RemoveLicenseResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "RemoveLicense: " + e.getMessage()));
            LOG.error((Object)"Exception during RemoveLicense", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasMessage() ? resp.getMessage() : Errno.toString((int)status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
        }
    }

    private void showCapabilities(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        License.ShowLicenseResponse resp;
        License.ShowLicenseRequest.Builder b = License.ShowLicenseRequest.newBuilder();
        b.setAll(false);
        b.setCreds(LicenseCommands.getLicenseCredentials(this.getUserCredentials()));
        try {
            byte[] data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShowLicenseProc.getNumber(), (MessageLite)b.build(), License.ShowLicenseResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShowLicenseProc.getNumber(), (MessageLite)b.build(), License.ShowLicenseResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = License.ShowLicenseResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "ShowLicense: " + e.getMessage()));
            LOG.error((Object)"Exception during AddLicense", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            String msg = resp.hasMessage() ? resp.getMessage() : Errno.toString((int)status);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, msg));
            return;
        }
        long time = System.currentTimeMillis();
        int now = (int)(time / 1000L);
        boolean hasJM = false;
        boolean spoofJM = true;
        for (License.LicenseInfo lInfo : resp.getLicenseInfoList()) {
            List cList = lInfo.getCapabilitiesList();
            boolean grace = lInfo.getExpirationdate() < (long)now;
            for (License.Capability c : cList) {
                CommandOutput.OutputHierarchy.OutputNode row = new CommandOutput.OutputHierarchy.OutputNode();
                out.addNode(row);
                CommandOutput.OutputHierarchy.OutputNode g = new CommandOutput.OutputHierarchy.OutputNode("grace", (Object)grace);
                row.addChild(g);
                String cap = c.getFeature().toString();
                CommandOutput.OutputHierarchy.OutputNode oc = new CommandOutput.OutputHierarchy.OutputNode("capability", (Object)cap);
                row.addChild(oc);
                if (c.hasFeatureData()) {
                    String fd = c.getFeatureData().hasMaxNfsNodes() ? c.getFeatureData().getMaxNfsNodes() : (c.getFeatureData().hasMaxNodes() ? c.getFeatureData().getMaxNodes() : "");
                    CommandOutput.OutputHierarchy.OutputNode fData = new CommandOutput.OutputHierarchy.OutputNode("featuredata", (Object)fd);
                    row.addChild(fData);
                }
                if (!c.hasName() || lInfo.getVersion().compareToIgnoreCase("5.0") >= 0 || lInfo.getLicType().getNumber() <= License.LicenseType.Registered.getNumber()) continue;
                if (c.getName().equalsIgnoreCase("SNAPSHOTS") || c.getName().equalsIgnoreCase("MIRRORING")) {
                    hasJM = true;
                    continue;
                }
                if (!c.getName().equalsIgnoreCase("JM_CHARTS") && !c.getName().equalsIgnoreCase("JM_HISTOGRAMS")) continue;
                spoofJM = false;
            }
        }
        if (spoofJM && hasJM) {
            CommandOutput.OutputHierarchy.OutputNode row1 = new CommandOutput.OutputHierarchy.OutputNode();
            row1.addChild(new CommandOutput.OutputHierarchy.OutputNode("grace", (Object)false));
            row1.addChild(new CommandOutput.OutputHierarchy.OutputNode("capability", (Object)"JM_CHARTS"));
            CommandOutput.OutputHierarchy.OutputNode row2 = new CommandOutput.OutputHierarchy.OutputNode();
            row2.addChild(new CommandOutput.OutputHierarchy.OutputNode("grace", (Object)false));
            row2.addChild(new CommandOutput.OutputHierarchy.OutputNode("capability", (Object)"JM_HISTOGRAMS"));
            out.addNode(row1);
            out.addNode(row2);
        }
    }
}

