/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.audit;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentFIFOHashMap<K, V> {
    private ConcurrentHashMap<K, V> map;
    private ConcurrentLinkedQueue<K> queue;
    private final int maxSize;

    ConcurrentFIFOHashMap(int maxSize) {
        this.maxSize = maxSize;
        this.map = new ConcurrentHashMap(maxSize);
        this.queue = new ConcurrentLinkedQueue();
    }

    public synchronized void put(K key, V value) {
        if (this.map.containsKey(key)) {
            return;
        }
        while (this.queue.size() >= this.maxSize) {
            K oldestKey = this.queue.poll();
            if (oldestKey == null) continue;
            this.map.remove(oldestKey);
        }
        this.queue.add(key);
        this.map.put(key, value);
    }

    public V get(K key) {
        return this.map.get(key);
    }
}

