/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Gtrace;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.login.common.TicketOptionalParams;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LogLevelChangesCommand
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(LogLevelChangesCommand.class);
    public static final String CLASS_NAME = "classname";
    public static final String LOG_LEVEL_NAME = "loglevel";
    public static final String NODE_IP = "node";
    public static final String PORT = "port";
    public static final String IS_USER_MODE = "isusermode";
    public static final CLICommand nfsChangeLogLevelCommand = new CLICommand(ServicesEnum.nfs.name(), "change log level for a class in NFS Server", LogLevelChangesCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"classname", (Object)new TextInputParameter("classname", "name of the module for which log level should be set. It should be one of listed under \"maprcli trace info\"", true, null)).put((Object)"loglevel", (Object)new TextInputParameter("loglevel", "Log Level: FATAL|ERROR|WARN|INFO|DEBUG|TRACE", true, null)).put((Object)"node", (Object)new TextInputParameter("node", "address of the node", true, null)).put((Object)"port", (Object)new IntegerInputParameter("port", "nfs port", false, null)).put((Object)"isusermode", (Object)new TextInputParameter("isusermode", "is user mode", false, null)).build(), null).setShortUsage("Setting log level for a particular class in a particluar service on a particular node");
    public static final CLICommand cldbChangeLogLevelCommand = new CLICommand(ServicesEnum.cldb.name(), "change log level for a class in CLDB", LogLevelChangesCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"classname", (Object)new TextInputParameter("classname", "name of the Java class for which log level should be set", true, null)).put((Object)"loglevel", (Object)new TextInputParameter("loglevel", "Log Level: FATAL|ERROR|WARN|INFO|DEBUG|TRACE", true, null)).put((Object)"node", (Object)new TextInputParameter("node", "address of the node", true, null)).put((Object)"port", (Object)new IntegerInputParameter("port", "CLDB port", false, null)).build(), null).setShortUsage("Setting log level for a particular class in a particluar service on a particular node");
    public static final CLICommand mfsChangeLogLevelCommand = new CLICommand(ServicesEnum.fileserver.name(), "change log level for a class in MFS Server", LogLevelChangesCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"classname", (Object)new TextInputParameter("classname", "name of the module for which log level should be set. It should be one of listed under \"maprcli trace info\"", true, null)).put((Object)"loglevel", (Object)new TextInputParameter("loglevel", "Log Level: FATAL|ERROR|WARN|INFO|DEBUG|TRACE", true, null)).put((Object)"node", (Object)new TextInputParameter("node", "address of the node", true, null)).put((Object)"port", (Object)new IntegerInputParameter("port", "mfs port", false, null)).build(), null).setShortUsage("Setting log level for a particular class in a particluar service on a particular node");
    String clusterName = null;
    static final String MARKER = "<!-- OUTPUT -->";
    static final Pattern TAG = Pattern.compile("<[^>]*>");

    public LogLevelChangesCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public boolean validateInput() throws IllegalArgumentException {
        if (!super.validateInput()) {
            return false;
        }
        try {
            String logLevel = this.getParamTextValue(LOG_LEVEL_NAME, 0);
            Level level = Level.toLevel((String)logLevel);
            if (level == Level.DEBUG && !logLevel.equalsIgnoreCase("DEBUG")) {
                LOG.error((Object)("Invalid log level: " + logLevel));
                this.output.getOutput().addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid log level").setField(LOG_LEVEL_NAME));
                return false;
            }
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)e);
            this.output.getOutput().addError(new CommandOutput.OutputHierarchy.OutputError(22, "Exception while processing log level param").setField(LOG_LEVEL_NAME));
            return false;
        }
        return true;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy ch = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(ch);
        this.clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        try {
            MapRLoginHttpsClient client = new MapRLoginHttpsClient();
            client.authenticateIfNeeded(this.clusterName);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception unable to authenticate ", (Throwable)e);
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "authentication failed"));
            return co;
        }
        block6: for (ServicesEnum service : ServicesEnum.values()) {
            if (!this.cliCommand.getCommandName().equalsIgnoreCase(service.name())) continue;
            switch (service) {
                case cldb: {
                    this.changeCLDBloglevel(ch);
                    continue block6;
                }
                case nfs: 
                case fileserver: {
                    this.setFSLogLevel(service, ch);
                    continue block6;
                }
                default: {
                    ch.addError(new CommandOutput.OutputHierarchy.OutputError(38, "Settting log level for service: " + service.name() + " is not implemented yet"));
                }
            }
        }
        return co;
    }

    private void changeCLDBloglevel(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String cldbHostString;
        String logLevel = this.getParamTextValue(LOG_LEVEL_NAME, 0);
        String className = this.getParamTextValue(CLASS_NAME, 0);
        int cldbPort = 7222;
        if (this.isParamPresent(PORT)) {
            cldbPort = this.getParamIntValue(PORT, 0);
        }
        if (!(cldbHostString = this.getParamTextValue(NODE_IP, 0)).equalsIgnoreCase("localhost") && !cldbHostString.equalsIgnoreCase("127.0.0.1")) {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(cldbHostString));
            if (ips.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not get valid IP address out of provided name: " + cldbHostString));
                return;
            }
            cldbHostString = ips.get(0);
        }
        int cldbHost = Util.ipToInt((String)cldbHostString);
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Failed to initalize RPC");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in Rpc.initialize " + e));
            throw new CLIProcessingException("Exception in Rpc.initialize " + e);
        }
        long binding = Rpc.createBindingFor((int)cldbHost, (int)cldbPort, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
        CLDBProto.ChangeLogLevelRequest req = CLDBProto.ChangeLogLevelRequest.newBuilder().setCreds(this.getUserCredentials()).setLogLevel(logLevel).setClassName(className).build();
        try {
            byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.CldbProgramId.getNumber(), (int)CLDBProto.CLDBProg.ChangeLogLevelProc.getNumber(), (MessageLite)req);
            if (replyData == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump changeloglevel rpc failed"));
                return;
            }
            CLDBProto.ChangeLogLevelResponse resp = CLDBProto.ChangeLogLevelResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                int status = resp.getStatus();
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Was not able to set loglevel for CLDB Node: " + cldbHostString + " with status: " + status));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception processing dump command " + e.getLocalizedMessage()));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "dump changeloglevel failed"));
        }
    }

    private void setFSLogLevel(ServicesEnum service, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        int port;
        try {
            port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                LOG.error((Object)"Error in RPC init");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Error in RPC init"));
                return;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in Rpc.initialize ", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Error in RPC init"));
            return;
        }
        try {
            Gtrace.GTraceResponse resp;
            MutableInt err;
            String hostName;
            port = Integer.valueOf(service.getPort());
            if (this.isParamPresent(PORT)) {
                port = this.getParamIntValue(PORT, 0);
            }
            if (!(hostName = this.getParamTextValue(NODE_IP, 0)).equalsIgnoreCase("localhost") && !hostName.equalsIgnoreCase("127.0.0.1")) {
                List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(hostName));
                if (ips.isEmpty()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not get valid IP address out of provided name: " + hostName));
                    return;
                }
                hostName = ips.get(0);
            }
            int hostip = Util.ipToInt((String)hostName);
            if (this.isParamPresent(IS_USER_MODE) && this.getParamTextValue(IS_USER_MODE, 0).equalsIgnoreCase("true") && (err = this.CreateNFSUserTicket(this.clusterName)).GetValue() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Cannot create the ticket for nfs in user mode"));
                return;
            }
            long binding = Rpc.createBindingFor((int)hostip, (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
            Gtrace.GTraceRequest.Builder req = Gtrace.GTraceRequest.newBuilder();
            req.setReqType(Gtrace.GTraceRequestType.setLevel);
            req.setModule(this.getParamTextValue(CLASS_NAME, 0));
            req.setLevel(this.getParamTextValue(LOG_LEVEL_NAME, 0));
            byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.GTraceProgramId.getNumber(), (int)Gtrace.GTraceProg.GTraceProc.getNumber(), (MessageLite)req.build());
            if (replyData == null) {
                LOG.error((Object)("null reponse while trying to set log level for: " + this.getParamTextValue(NODE_IP, 0) + ":" + port));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "null reponse while trying to set log level for: " + this.getParamTextValue(NODE_IP, 0) + ":" + port));
            }
            if ((resp = Gtrace.GTraceResponse.parseFrom((byte[])replyData)).getStatus() == 22) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Operation failed :(EINVAL) Invalid parameters"));
            }
            if (resp.getStatus() == 12) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(12, "Operation failed :(ENOMEM) could not allocate memory"));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Exception during setLogLevel processing"));
        }
    }

    private MutableInt CreateNFSUserTicket(String clusterName) {
        MutableInt err = new MutableInt();
        Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)clusterName, (MutableInt)err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (Security.Key)ticketAndKey.getUserKey());
        String userName = ticketAndKey.getUserCreds().getUserName();
        int[] gids = new int[]{userName.length()};
        TicketOptionalParams tOptionalParams = new TicketOptionalParams();
        tOptionalParams.setIsExternal(true);
        ticketAndKey = Security.GenerateTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)userName, (int)userName.length(), (int[])gids, (long)Security.MAX_EXPIRY_TIME, (long)0L, (TicketOptionalParams)tOptionalParams, (MutableInt)err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)clusterName, (Security.TicketAndKey)ticketAndKey);
        return err;
    }
}

